package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.AsyncHandler;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AsyncHandlerConsumer<T extends AsyncHandler<T>> {

	/**
	 * Configure a pre-constructed instance of AsyncHandler resource
	 * 
	 * @parameter Instance of AsyncHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default AsyncHandlerConsumer<T> andThen(AsyncHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}