package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.XmlFormatter;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface XmlFormatterConsumer<T extends XmlFormatter<T>> {

	/**
	 * Configure a pre-constructed instance of XmlFormatter resource
	 * 
	 * @parameter Instance of XmlFormatter to configure
	 * @return nothing
	 */
	void accept(T value);

	default XmlFormatterConsumer<T> andThen(XmlFormatterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}