package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraint;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ApplicationClassificationConstraintConsumer<T extends ApplicationClassificationConstraint<T>> {

	/**
	 * Configure a pre-constructed instance of
	 * ApplicationClassificationConstraint resource
	 * 
	 * @parameter Instance of ApplicationClassificationConstraint to configure
	 * @return nothing
	 */
	void accept(T value);

	default ApplicationClassificationConstraintConsumer<T> andThen(
			ApplicationClassificationConstraintConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}