package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.InMemoryHandler;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface InMemoryHandlerConsumer<T extends InMemoryHandler<T>> {

	/**
	 * Configure a pre-constructed instance of InMemoryHandler resource
	 * 
	 * @parameter Instance of InMemoryHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default InMemoryHandlerConsumer<T> andThen(InMemoryHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}