package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.LdapAuthorization;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LdapAuthorizationConsumer<T extends LdapAuthorization<T>> {

	/**
	 * Configure a pre-constructed instance of LdapAuthorization resource
	 * 
	 * @parameter Instance of LdapAuthorization to configure
	 * @return nothing
	 */
	void accept(T value);

	default LdapAuthorizationConsumer<T> andThen(
			LdapAuthorizationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}