package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.messaging.activemq.FactoryType;

/**
 * Defines a connection factory.
 */
@Address("/subsystem=messaging-activemq/connection-factory=*")
@ResourceType("connection-factory")
public class ConnectionFactory<T extends ConnectionFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.")
	private List<String> connectors;
	@AttributeDocumentation("The discovery group name.")
	private String discoveryGroup;
	@AttributeDocumentation("The jndi names the connection factory should be bound to.")
	private List<String> entries;
	@AttributeDocumentation("The type of connection factory.")
	private FactoryType factoryType;
	@AttributeDocumentation("Whether the connection factory supports High Availability.")
	private Boolean ha;

	public ConnectionFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(java.util.List<String> value) {
		Object oldValue = this.connectors;
		this.connectors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectors", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connector(String value) {
		if (this.connectors == null) {
			this.connectors = new java.util.ArrayList<>();
		}
		this.connectors.add(value);
		return (T) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(String... args) {
		connectors(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The discovery group name.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The discovery group name.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String value) {
		Object oldValue = this.discoveryGroup;
		this.discoveryGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("discoveryGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(java.util.List<String> value) {
		Object oldValue = this.entries;
		this.entries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("entries", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entry(String value) {
		if (this.entries == null) {
			this.entries = new java.util.ArrayList<>();
		}
		this.entries.add(value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(String... args) {
		entries(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The type of connection factory.
	 */
	@ModelNodeBinding(detypedName = "factory-type")
	public FactoryType factoryType() {
		return this.factoryType;
	}

	/**
	 * The type of connection factory.
	 */
	@SuppressWarnings("unchecked")
	public T factoryType(FactoryType value) {
		Object oldValue = this.factoryType;
		this.factoryType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("factoryType", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@ModelNodeBinding(detypedName = "ha")
	public Boolean ha() {
		return this.ha;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@SuppressWarnings("unchecked")
	public T ha(java.lang.Boolean value) {
		Object oldValue = this.ha;
		this.ha = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ha", oldValue, value);
		return (T) this;
	}
}