package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.messaging.activemq.Connector;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConnectorConsumer<T extends Connector<T>> {

	/**
	 * Configure a pre-constructed instance of Connector resource
	 * 
	 * @parameter Instance of Connector to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConnectorConsumer<T> andThen(ConnectorConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}