package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.Map;

/**
 * A JMS bridge instance.
 */
@Address("/subsystem=messaging-activemq/jms-bridge=*")
@ResourceType("jms-bridge")
public class JMSBridge<T extends JMSBridge<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("If true, then the original message's message ID will be appended in the message sent to the destination in the header AMQ_BRIDGE_MSG_ID_LIST. If the message is bridged more than once, each message ID will be appended.")
	private Boolean addMessageidInHeader;
	@AttributeDocumentation("The JMS client ID to use when creating/looking up the subscription if it is durable and the source destination is a topic.")
	private String clientId;
	@AttributeDocumentation("The amount of time in milliseconds to wait between trying to recreate connections to the source or target servers when the bridge has detected they have failed.")
	private Long failureRetryInterval;
	@AttributeDocumentation("The maximum number of messages to consume from the source destination before sending them in a batch to the target destination. Its value must >= 1.")
	private Integer maxBatchSize;
	@AttributeDocumentation("The maximum number of milliseconds to wait before sending a batch to target, even if the number of messages consumed has not reached max-batch-size. Its value must be -1 to represent 'wait forever', or >= 1 to specify an actual time.")
	private Long maxBatchTime;
	@AttributeDocumentation("The number of times to attempt to recreate connections to the source or target servers when the bridge has detected they have failed. The bridge will give up after trying this number of times. -1 represents 'try forever'.")
	private Integer maxRetries;
	@AttributeDocumentation("The name of AS7 module containing the resources required to lookup source and target JMS resources.")
	private String module;
	@AttributeDocumentation("Whether the JMS bridge is paused.")
	private Boolean paused;
	@AttributeDocumentation("The desired quality of service mode (AT_MOST_ONCE, DUPLICATES_OK or ONCE_AND_ONLY_ONCE).")
	private QualityOfService qualityOfService;
	@AttributeDocumentation("A JMS selector expression used for consuming messages from the source destination. Only messages that match the selector expression will be bridged from the source to the target destination.")
	private String selector;
	@AttributeDocumentation("The name of the source connection factory to lookup on the source messaging server.")
	private String sourceConnectionFactory;
	@AttributeDocumentation("The properties used to configure the source JNDI initial context.")
	private Map sourceContext;
	@AttributeDocumentation("Credential (from Credential Store) to authenticate source connection")
	private Map sourceCredentialReference;
	@AttributeDocumentation("The name of the source destination to lookup on the source messaging server.")
	private String sourceDestination;
	@AttributeDocumentation("The password for creating the source connection.")
	private String sourcePassword;
	@AttributeDocumentation("The name of the user for creating the source connection.")
	private String sourceUser;
	@AttributeDocumentation("Whether the JMS bridge is started.")
	private Boolean started;
	@AttributeDocumentation("The name of the subscription if it is durable and the source destination is a topic.")
	private String subscriptionName;
	@AttributeDocumentation("The name of the target connection factory to lookup on the target messaging server.")
	private String targetConnectionFactory;
	@AttributeDocumentation("The properties used to configure the target JNDI initial context.")
	private Map targetContext;
	@AttributeDocumentation("Credential (from Credential Store) to authenticate target connection")
	private Map targetCredentialReference;
	@AttributeDocumentation("The name of the target destination to lookup on the target messaging server.")
	private String targetDestination;
	@AttributeDocumentation("The password for creating the target connection.")
	private String targetPassword;
	@AttributeDocumentation("The name of the user for creating the target connection.")
	private String targetUser;

	public JMSBridge(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum QualityOfService {
		AT_MOST_ONCE("AT_MOST_ONCE"), DUPLICATES_OK("DUPLICATES_OK"), ONCE_AND_ONLY_ONCE(
				"ONCE_AND_ONLY_ONCE");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		QualityOfService(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * If true, then the original message's message ID will be appended in the
	 * message sent to the destination in the header AMQ_BRIDGE_MSG_ID_LIST. If
	 * the message is bridged more than once, each message ID will be appended.
	 */
	@ModelNodeBinding(detypedName = "add-messageID-in-header")
	public Boolean addMessageidInHeader() {
		return this.addMessageidInHeader;
	}

	/**
	 * If true, then the original message's message ID will be appended in the
	 * message sent to the destination in the header AMQ_BRIDGE_MSG_ID_LIST. If
	 * the message is bridged more than once, each message ID will be appended.
	 */
	@SuppressWarnings("unchecked")
	public T addMessageidInHeader(java.lang.Boolean value) {
		Object oldValue = this.addMessageidInHeader;
		this.addMessageidInHeader = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("addMessageidInHeader", oldValue, value);
		return (T) this;
	}

	/**
	 * The JMS client ID to use when creating/looking up the subscription if it
	 * is durable and the source destination is a topic.
	 */
	@ModelNodeBinding(detypedName = "client-id")
	public String clientId() {
		return this.clientId;
	}

	/**
	 * The JMS client ID to use when creating/looking up the subscription if it
	 * is durable and the source destination is a topic.
	 */
	@SuppressWarnings("unchecked")
	public T clientId(java.lang.String value) {
		Object oldValue = this.clientId;
		this.clientId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientId", oldValue, value);
		return (T) this;
	}

	/**
	 * The amount of time in milliseconds to wait between trying to recreate
	 * connections to the source or target servers when the bridge has detected
	 * they have failed.
	 */
	@ModelNodeBinding(detypedName = "failure-retry-interval")
	public Long failureRetryInterval() {
		return this.failureRetryInterval;
	}

	/**
	 * The amount of time in milliseconds to wait between trying to recreate
	 * connections to the source or target servers when the bridge has detected
	 * they have failed.
	 */
	@SuppressWarnings("unchecked")
	public T failureRetryInterval(java.lang.Long value) {
		Object oldValue = this.failureRetryInterval;
		this.failureRetryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failureRetryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of messages to consume from the source destination
	 * before sending them in a batch to the target destination. Its value must
	 * >= 1.
	 */
	@ModelNodeBinding(detypedName = "max-batch-size")
	public Integer maxBatchSize() {
		return this.maxBatchSize;
	}

	/**
	 * The maximum number of messages to consume from the source destination
	 * before sending them in a batch to the target destination. Its value must
	 * >= 1.
	 */
	@SuppressWarnings("unchecked")
	public T maxBatchSize(java.lang.Integer value) {
		Object oldValue = this.maxBatchSize;
		this.maxBatchSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxBatchSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of milliseconds to wait before sending a batch to
	 * target, even if the number of messages consumed has not reached
	 * max-batch-size. Its value must be -1 to represent 'wait forever', or >= 1
	 * to specify an actual time.
	 */
	@ModelNodeBinding(detypedName = "max-batch-time")
	public Long maxBatchTime() {
		return this.maxBatchTime;
	}

	/**
	 * The maximum number of milliseconds to wait before sending a batch to
	 * target, even if the number of messages consumed has not reached
	 * max-batch-size. Its value must be -1 to represent 'wait forever', or >= 1
	 * to specify an actual time.
	 */
	@SuppressWarnings("unchecked")
	public T maxBatchTime(java.lang.Long value) {
		Object oldValue = this.maxBatchTime;
		this.maxBatchTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxBatchTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of times to attempt to recreate connections to the source or
	 * target servers when the bridge has detected they have failed. The bridge
	 * will give up after trying this number of times. -1 represents 'try
	 * forever'.
	 */
	@ModelNodeBinding(detypedName = "max-retries")
	public Integer maxRetries() {
		return this.maxRetries;
	}

	/**
	 * The number of times to attempt to recreate connections to the source or
	 * target servers when the bridge has detected they have failed. The bridge
	 * will give up after trying this number of times. -1 represents 'try
	 * forever'.
	 */
	@SuppressWarnings("unchecked")
	public T maxRetries(java.lang.Integer value) {
		Object oldValue = this.maxRetries;
		this.maxRetries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRetries", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of AS7 module containing the resources required to lookup source
	 * and target JMS resources.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The name of AS7 module containing the resources required to lookup source
	 * and target JMS resources.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the JMS bridge is paused.
	 */
	@ModelNodeBinding(detypedName = "paused")
	public Boolean paused() {
		return this.paused;
	}

	/**
	 * Whether the JMS bridge is paused.
	 */
	@SuppressWarnings("unchecked")
	public T paused(java.lang.Boolean value) {
		Object oldValue = this.paused;
		this.paused = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("paused", oldValue, value);
		return (T) this;
	}

	/**
	 * The desired quality of service mode (AT_MOST_ONCE, DUPLICATES_OK or
	 * ONCE_AND_ONLY_ONCE).
	 */
	@ModelNodeBinding(detypedName = "quality-of-service")
	public QualityOfService qualityOfService() {
		return this.qualityOfService;
	}

	/**
	 * The desired quality of service mode (AT_MOST_ONCE, DUPLICATES_OK or
	 * ONCE_AND_ONLY_ONCE).
	 */
	@SuppressWarnings("unchecked")
	public T qualityOfService(QualityOfService value) {
		Object oldValue = this.qualityOfService;
		this.qualityOfService = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("qualityOfService", oldValue, value);
		return (T) this;
	}

	/**
	 * A JMS selector expression used for consuming messages from the source
	 * destination. Only messages that match the selector expression will be
	 * bridged from the source to the target destination.
	 */
	@ModelNodeBinding(detypedName = "selector")
	public String selector() {
		return this.selector;
	}

	/**
	 * A JMS selector expression used for consuming messages from the source
	 * destination. Only messages that match the selector expression will be
	 * bridged from the source to the target destination.
	 */
	@SuppressWarnings("unchecked")
	public T selector(java.lang.String value) {
		Object oldValue = this.selector;
		this.selector = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("selector", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the source connection factory to lookup on the source
	 * messaging server.
	 */
	@ModelNodeBinding(detypedName = "source-connection-factory")
	public String sourceConnectionFactory() {
		return this.sourceConnectionFactory;
	}

	/**
	 * The name of the source connection factory to lookup on the source
	 * messaging server.
	 */
	@SuppressWarnings("unchecked")
	public T sourceConnectionFactory(java.lang.String value) {
		Object oldValue = this.sourceConnectionFactory;
		this.sourceConnectionFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sourceConnectionFactory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The properties used to configure the source JNDI initial context.
	 */
	@ModelNodeBinding(detypedName = "source-context")
	public Map sourceContext() {
		return this.sourceContext;
	}

	/**
	 * The properties used to configure the source JNDI initial context.
	 */
	@SuppressWarnings("unchecked")
	public T sourceContext(java.util.Map value) {
		Object oldValue = this.sourceContext;
		this.sourceContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sourceContext", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties used to configure the source JNDI initial context.
	 */
	@SuppressWarnings("unchecked")
	public T sourceContext(java.lang.String key, java.lang.Object value) {
		if (this.sourceContext == null) {
			this.sourceContext = new java.util.HashMap<>();
		}
		this.sourceContext.put(key, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate source connection
	 */
	@ModelNodeBinding(detypedName = "source-credential-reference")
	public Map sourceCredentialReference() {
		return this.sourceCredentialReference;
	}

	/**
	 * Credential (from Credential Store) to authenticate source connection
	 */
	@SuppressWarnings("unchecked")
	public T sourceCredentialReference(java.util.Map value) {
		Object oldValue = this.sourceCredentialReference;
		this.sourceCredentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sourceCredentialReference", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate source connection
	 */
	@SuppressWarnings("unchecked")
	public T sourceCredentialReference(java.lang.String key,
			java.lang.Object value) {
		if (this.sourceCredentialReference == null) {
			this.sourceCredentialReference = new java.util.HashMap<>();
		}
		this.sourceCredentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The name of the source destination to lookup on the source messaging
	 * server.
	 */
	@ModelNodeBinding(detypedName = "source-destination")
	public String sourceDestination() {
		return this.sourceDestination;
	}

	/**
	 * The name of the source destination to lookup on the source messaging
	 * server.
	 */
	@SuppressWarnings("unchecked")
	public T sourceDestination(java.lang.String value) {
		Object oldValue = this.sourceDestination;
		this.sourceDestination = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sourceDestination", oldValue, value);
		return (T) this;
	}

	/**
	 * The password for creating the source connection.
	 */
	@ModelNodeBinding(detypedName = "source-password")
	public String sourcePassword() {
		return this.sourcePassword;
	}

	/**
	 * The password for creating the source connection.
	 */
	@SuppressWarnings("unchecked")
	public T sourcePassword(java.lang.String value) {
		Object oldValue = this.sourcePassword;
		this.sourcePassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sourcePassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the user for creating the source connection.
	 */
	@ModelNodeBinding(detypedName = "source-user")
	public String sourceUser() {
		return this.sourceUser;
	}

	/**
	 * The name of the user for creating the source connection.
	 */
	@SuppressWarnings("unchecked")
	public T sourceUser(java.lang.String value) {
		Object oldValue = this.sourceUser;
		this.sourceUser = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sourceUser", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the JMS bridge is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether the JMS bridge is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(java.lang.Boolean value) {
		Object oldValue = this.started;
		this.started = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("started", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the subscription if it is durable and the source destination
	 * is a topic.
	 */
	@ModelNodeBinding(detypedName = "subscription-name")
	public String subscriptionName() {
		return this.subscriptionName;
	}

	/**
	 * The name of the subscription if it is durable and the source destination
	 * is a topic.
	 */
	@SuppressWarnings("unchecked")
	public T subscriptionName(java.lang.String value) {
		Object oldValue = this.subscriptionName;
		this.subscriptionName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("subscriptionName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the target connection factory to lookup on the target
	 * messaging server.
	 */
	@ModelNodeBinding(detypedName = "target-connection-factory")
	public String targetConnectionFactory() {
		return this.targetConnectionFactory;
	}

	/**
	 * The name of the target connection factory to lookup on the target
	 * messaging server.
	 */
	@SuppressWarnings("unchecked")
	public T targetConnectionFactory(java.lang.String value) {
		Object oldValue = this.targetConnectionFactory;
		this.targetConnectionFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("targetConnectionFactory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The properties used to configure the target JNDI initial context.
	 */
	@ModelNodeBinding(detypedName = "target-context")
	public Map targetContext() {
		return this.targetContext;
	}

	/**
	 * The properties used to configure the target JNDI initial context.
	 */
	@SuppressWarnings("unchecked")
	public T targetContext(java.util.Map value) {
		Object oldValue = this.targetContext;
		this.targetContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("targetContext", oldValue, value);
		return (T) this;
	}

	/**
	 * The properties used to configure the target JNDI initial context.
	 */
	@SuppressWarnings("unchecked")
	public T targetContext(java.lang.String key, java.lang.Object value) {
		if (this.targetContext == null) {
			this.targetContext = new java.util.HashMap<>();
		}
		this.targetContext.put(key, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate target connection
	 */
	@ModelNodeBinding(detypedName = "target-credential-reference")
	public Map targetCredentialReference() {
		return this.targetCredentialReference;
	}

	/**
	 * Credential (from Credential Store) to authenticate target connection
	 */
	@SuppressWarnings("unchecked")
	public T targetCredentialReference(java.util.Map value) {
		Object oldValue = this.targetCredentialReference;
		this.targetCredentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("targetCredentialReference", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate target connection
	 */
	@SuppressWarnings("unchecked")
	public T targetCredentialReference(java.lang.String key,
			java.lang.Object value) {
		if (this.targetCredentialReference == null) {
			this.targetCredentialReference = new java.util.HashMap<>();
		}
		this.targetCredentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The name of the target destination to lookup on the target messaging
	 * server.
	 */
	@ModelNodeBinding(detypedName = "target-destination")
	public String targetDestination() {
		return this.targetDestination;
	}

	/**
	 * The name of the target destination to lookup on the target messaging
	 * server.
	 */
	@SuppressWarnings("unchecked")
	public T targetDestination(java.lang.String value) {
		Object oldValue = this.targetDestination;
		this.targetDestination = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("targetDestination", oldValue, value);
		return (T) this;
	}

	/**
	 * The password for creating the target connection.
	 */
	@ModelNodeBinding(detypedName = "target-password")
	public String targetPassword() {
		return this.targetPassword;
	}

	/**
	 * The password for creating the target connection.
	 */
	@SuppressWarnings("unchecked")
	public T targetPassword(java.lang.String value) {
		Object oldValue = this.targetPassword;
		this.targetPassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("targetPassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the user for creating the target connection.
	 */
	@ModelNodeBinding(detypedName = "target-user")
	public String targetUser() {
		return this.targetUser;
	}

	/**
	 * The name of the user for creating the target connection.
	 */
	@SuppressWarnings("unchecked")
	public T targetUser(java.lang.String value) {
		Object oldValue = this.targetUser;
		this.targetUser = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("targetUser", oldValue, value);
		return (T) this;
	}
}