package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.messaging.activemq.JMSBridge;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JMSBridgeConsumer<T extends JMSBridge<T>> {

	/**
	 * Configure a pre-constructed instance of JMSBridge resource
	 * 
	 * @parameter Instance of JMSBridge to configure
	 * @return nothing
	 */
	void accept(T value);

	default JMSBridgeConsumer<T> andThen(JMSBridgeConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}