package org.wildfly.swarm.config.messaging.activemq;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.Map;

/**
 * Defines a managed connection factory.
 */
@Addresses({"/subsystem=messaging-activemq/pooled-connection-factory=*",
		"/subsystem=messaging-activemq/server=*/pooled-connection-factory=*"})
@ResourceType("pooled-connection-factory")
public class PooledConnectionFactory<T extends PooledConnectionFactory<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Allow local transactions for outbond JMS Sessions (it does not apply to JMSContext that explicitly disallows it).")
	private Boolean allowLocalTransactions;
	@AttributeDocumentation("The autogroup.")
	private Boolean autoGroup;
	@AttributeDocumentation("True to set block on acknowledge.")
	private Boolean blockOnAcknowledge;
	@AttributeDocumentation("True to set block on durable send.")
	private Boolean blockOnDurableSend;
	@AttributeDocumentation("True to set block on non durable send.")
	private Boolean blockOnNonDurableSend;
	@AttributeDocumentation("True to cache large messages.")
	private Boolean cacheLargeMessageClient;
	@AttributeDocumentation("The timeout to use when fail over is in process (in ms).")
	private Long callFailoverTimeout;
	@AttributeDocumentation("The call time out.")
	private Long callTimeout;
	@AttributeDocumentation("The client failure check period.")
	private Long clientFailureCheckPeriod;
	@AttributeDocumentation("The client id.")
	private String clientId;
	@AttributeDocumentation("Whether large messages should be compressed.")
	private Boolean compressLargeMessages;
	@AttributeDocumentation("The confirmation window size.")
	private Integer confirmationWindowSize;
	@AttributeDocumentation("Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.")
	private String connectionLoadBalancingPolicyClassName;
	@AttributeDocumentation("The connection ttl.")
	private Long connectionTtl;
	@AttributeDocumentation("Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.")
	private List<String> connectors;
	@AttributeDocumentation("The consumer max rate.")
	private Integer consumerMaxRate;
	@AttributeDocumentation("The consumer window size.")
	private Integer consumerWindowSize;
	@AttributeDocumentation("Credential (from Credential Store) to authenticate the pooled connection factory")
	private Map credentialReference;
	@AttributeDocumentation("A list of class names (separated by whitespaces) that are black-listed to be used in serialization of JMS ObjectMessage.")
	private List<String> deserializationBlackList;
	@AttributeDocumentation("A list of class names (separated by whitespaces) that are white-listed to be used in serialization of JMS ObjectMessage.")
	private List<String> deserializationWhiteList;
	@AttributeDocumentation("The discovery group name.")
	private String discoveryGroup;
	@AttributeDocumentation("The dups ok batch size.")
	private Integer dupsOkBatchSize;
	@AttributeDocumentation("Enables IronJacamar to record enlistment traces for this pooled-connection-factory. This attribute is undefined by default and the behaviour is driven by the presence of the ironjacamar.disable_enlistment_trace system property.")
	private Boolean enlistmentTrace;
	@AttributeDocumentation("The jndi names the connection factory should be bound to.")
	private List<String> entries;
	@AttributeDocumentation("True to fail over on initial connection.")
	private Boolean failoverOnInitialConnection;
	@AttributeDocumentation("The group id.")
	private String groupId;
	@AttributeDocumentation("Whether the connection factory supports High Availability.")
	private Boolean ha;
	@AttributeDocumentation("The number of attempts to connect initially with this factory.")
	private Integer initialConnectAttempts;
	@AttributeDocumentation("The initial size of messages created through this factory.")
	private Integer initialMessagePacketSize;
	@AttributeDocumentation("The JNDI params to use for locating the destination for incoming connections.")
	private String jndiParams;
	@AttributeDocumentation("The class name of the managed connection pool used by this pooled-connection-factory.")
	private String managedConnectionPool;
	@AttributeDocumentation("The maximum size for the pool")
	private Integer maxPoolSize;
	@AttributeDocumentation("The max retry interval.")
	private Long maxRetryInterval;
	@AttributeDocumentation("The min large message size.")
	private Integer minLargeMessageSize;
	@AttributeDocumentation("The minimum size for the pool")
	private Integer minPoolSize;
	@AttributeDocumentation("The default password to use with this connection factory. This is only needed when pointing the connection factory to a remote host.")
	private String password;
	@AttributeDocumentation("True to pre-acknowledge.")
	private Boolean preAcknowledge;
	@AttributeDocumentation("The producer max rate.")
	private Integer producerMaxRate;
	@AttributeDocumentation("The producer window size.")
	private Integer producerWindowSize;
	@AttributeDocumentation("The protocol manager factory used by this pooled connection factory.")
	private String protocolManagerFactory;
	@AttributeDocumentation("Rebalance inbound connections when cluster topology changes.")
	private Boolean rebalanceConnections;
	@AttributeDocumentation("The reconnect attempts. By default, a pooled connection factory will try to reconnect infinitely to the messaging server(s).")
	private Integer reconnectAttempts;
	@AttributeDocumentation("The retry interval.")
	private Long retryInterval;
	@AttributeDocumentation("The retry interval multiplier.")
	private Double retryIntervalMultiplier;
	@AttributeDocumentation("The scheduled thread pool max size.")
	private Integer scheduledThreadPoolMaxSize;
	@AttributeDocumentation("The number of times to set up an MDB endpoint")
	private Integer setupAttempts;
	@AttributeDocumentation("The interval between attempts at setting up an MDB endpoint.")
	private Long setupInterval;
	@AttributeDocumentation("Define whether runtime statistics are enabled.")
	private Boolean statisticsEnabled;
	@AttributeDocumentation("The thread pool max size.")
	private Integer threadPoolMaxSize;
	@AttributeDocumentation("The type of transaction supported by this pooled connection factory (can be LOCAL, NONE or XA, default is XA).")
	private String transaction;
	@AttributeDocumentation("The transaction batch size.")
	private Integer transactionBatchSize;
	@AttributeDocumentation("True to use auto recovery.")
	private Boolean useAutoRecovery;
	@AttributeDocumentation("True to use global pools.")
	private Boolean useGlobalPools;
	@AttributeDocumentation("Use JNDI to locate the destination for incoming connections")
	private Boolean useJndi;
	@AttributeDocumentation("Use a local transaction for incoming sessions")
	private Boolean useLocalTx;
	@AttributeDocumentation("The default username to use with this connection factory. This is only needed when pointing the connection factory to a remote host.")
	private String user;

	public PooledConnectionFactory(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Allow local transactions for outbond JMS Sessions (it does not apply to
	 * JMSContext that explicitly disallows it).
	 */
	@ModelNodeBinding(detypedName = "allow-local-transactions")
	public Boolean allowLocalTransactions() {
		return this.allowLocalTransactions;
	}

	/**
	 * Allow local transactions for outbond JMS Sessions (it does not apply to
	 * JMSContext that explicitly disallows it).
	 */
	@SuppressWarnings("unchecked")
	public T allowLocalTransactions(java.lang.Boolean value) {
		Object oldValue = this.allowLocalTransactions;
		this.allowLocalTransactions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowLocalTransactions", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The autogroup.
	 */
	@ModelNodeBinding(detypedName = "auto-group")
	public Boolean autoGroup() {
		return this.autoGroup;
	}

	/**
	 * The autogroup.
	 */
	@SuppressWarnings("unchecked")
	public T autoGroup(java.lang.Boolean value) {
		Object oldValue = this.autoGroup;
		this.autoGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@ModelNodeBinding(detypedName = "block-on-acknowledge")
	public Boolean blockOnAcknowledge() {
		return this.blockOnAcknowledge;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public T blockOnAcknowledge(java.lang.Boolean value) {
		Object oldValue = this.blockOnAcknowledge;
		this.blockOnAcknowledge = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("blockOnAcknowledge", oldValue, value);
		return (T) this;
	}

	/**
	 * True to set block on durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-durable-send")
	public Boolean blockOnDurableSend() {
		return this.blockOnDurableSend;
	}

	/**
	 * True to set block on durable send.
	 */
	@SuppressWarnings("unchecked")
	public T blockOnDurableSend(java.lang.Boolean value) {
		Object oldValue = this.blockOnDurableSend;
		this.blockOnDurableSend = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("blockOnDurableSend", oldValue, value);
		return (T) this;
	}

	/**
	 * True to set block on non durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-non-durable-send")
	public Boolean blockOnNonDurableSend() {
		return this.blockOnNonDurableSend;
	}

	/**
	 * True to set block on non durable send.
	 */
	@SuppressWarnings("unchecked")
	public T blockOnNonDurableSend(java.lang.Boolean value) {
		Object oldValue = this.blockOnNonDurableSend;
		this.blockOnNonDurableSend = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("blockOnNonDurableSend", oldValue,
					value);
		return (T) this;
	}

	/**
	 * True to cache large messages.
	 */
	@ModelNodeBinding(detypedName = "cache-large-message-client")
	public Boolean cacheLargeMessageClient() {
		return this.cacheLargeMessageClient;
	}

	/**
	 * True to cache large messages.
	 */
	@SuppressWarnings("unchecked")
	public T cacheLargeMessageClient(java.lang.Boolean value) {
		Object oldValue = this.cacheLargeMessageClient;
		this.cacheLargeMessageClient = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheLargeMessageClient", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@ModelNodeBinding(detypedName = "call-failover-timeout")
	public Long callFailoverTimeout() {
		return this.callFailoverTimeout;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@SuppressWarnings("unchecked")
	public T callFailoverTimeout(java.lang.Long value) {
		Object oldValue = this.callFailoverTimeout;
		this.callFailoverTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("callFailoverTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The call time out.
	 */
	@ModelNodeBinding(detypedName = "call-timeout")
	public Long callTimeout() {
		return this.callTimeout;
	}

	/**
	 * The call time out.
	 */
	@SuppressWarnings("unchecked")
	public T callTimeout(java.lang.Long value) {
		Object oldValue = this.callTimeout;
		this.callTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("callTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The client failure check period.
	 */
	@ModelNodeBinding(detypedName = "client-failure-check-period")
	public Long clientFailureCheckPeriod() {
		return this.clientFailureCheckPeriod;
	}

	/**
	 * The client failure check period.
	 */
	@SuppressWarnings("unchecked")
	public T clientFailureCheckPeriod(java.lang.Long value) {
		Object oldValue = this.clientFailureCheckPeriod;
		this.clientFailureCheckPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientFailureCheckPeriod", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The client id.
	 */
	@ModelNodeBinding(detypedName = "client-id")
	public String clientId() {
		return this.clientId;
	}

	/**
	 * The client id.
	 */
	@SuppressWarnings("unchecked")
	public T clientId(java.lang.String value) {
		Object oldValue = this.clientId;
		this.clientId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientId", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@ModelNodeBinding(detypedName = "compress-large-messages")
	public Boolean compressLargeMessages() {
		return this.compressLargeMessages;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@SuppressWarnings("unchecked")
	public T compressLargeMessages(java.lang.Boolean value) {
		Object oldValue = this.compressLargeMessages;
		this.compressLargeMessages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("compressLargeMessages", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The confirmation window size.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation window size.
	 */
	@SuppressWarnings("unchecked")
	public T confirmationWindowSize(java.lang.Integer value) {
		Object oldValue = this.confirmationWindowSize;
		this.confirmationWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("confirmationWindowSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a
	 * client can use to load balance sessions across different nodes in a
	 * cluster.
	 */
	@ModelNodeBinding(detypedName = "connection-load-balancing-policy-class-name")
	public String connectionLoadBalancingPolicyClassName() {
		return this.connectionLoadBalancingPolicyClassName;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a
	 * client can use to load balance sessions across different nodes in a
	 * cluster.
	 */
	@SuppressWarnings("unchecked")
	public T connectionLoadBalancingPolicyClassName(java.lang.String value) {
		Object oldValue = this.connectionLoadBalancingPolicyClassName;
		this.connectionLoadBalancingPolicyClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange(
					"connectionLoadBalancingPolicyClassName", oldValue, value);
		return (T) this;
	}

	/**
	 * The connection ttl.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The connection ttl.
	 */
	@SuppressWarnings("unchecked")
	public T connectionTtl(java.lang.Long value) {
		Object oldValue = this.connectionTtl;
		this.connectionTtl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionTtl", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(java.util.List<String> value) {
		Object oldValue = this.connectors;
		this.connectors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectors", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connector(String value) {
		if (this.connectors == null) {
			this.connectors = new java.util.ArrayList<>();
		}
		this.connectors.add(value);
		return (T) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with
	 * an undefined value). It is possible to pass a list of connector names
	 * when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(String... args) {
		connectors(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The consumer max rate.
	 */
	@ModelNodeBinding(detypedName = "consumer-max-rate")
	public Integer consumerMaxRate() {
		return this.consumerMaxRate;
	}

	/**
	 * The consumer max rate.
	 */
	@SuppressWarnings("unchecked")
	public T consumerMaxRate(java.lang.Integer value) {
		Object oldValue = this.consumerMaxRate;
		this.consumerMaxRate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consumerMaxRate", oldValue, value);
		return (T) this;
	}

	/**
	 * The consumer window size.
	 */
	@ModelNodeBinding(detypedName = "consumer-window-size")
	public Integer consumerWindowSize() {
		return this.consumerWindowSize;
	}

	/**
	 * The consumer window size.
	 */
	@SuppressWarnings("unchecked")
	public T consumerWindowSize(java.lang.Integer value) {
		Object oldValue = this.consumerWindowSize;
		this.consumerWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consumerWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate the pooled connection
	 * factory
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * Credential (from Credential Store) to authenticate the pooled connection
	 * factory
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate the pooled connection
	 * factory
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * A list of class names (separated by whitespaces) that are black-listed to
	 * be used in serialization of JMS ObjectMessage.
	 */
	@ModelNodeBinding(detypedName = "deserialization-black-list")
	public List<String> deserializationBlackList() {
		return this.deserializationBlackList;
	}

	/**
	 * A list of class names (separated by whitespaces) that are black-listed to
	 * be used in serialization of JMS ObjectMessage.
	 */
	@SuppressWarnings("unchecked")
	public T deserializationBlackList(java.util.List<String> value) {
		Object oldValue = this.deserializationBlackList;
		this.deserializationBlackList = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deserializationBlackList", oldValue,
					value);
		return (T) this;
	}

	/**
	 * A list of class names (separated by whitespaces) that are black-listed to
	 * be used in serialization of JMS ObjectMessage.
	 */
	@SuppressWarnings("unchecked")
	public T deserializationBlackList(String value) {
		if (this.deserializationBlackList == null) {
			this.deserializationBlackList = new java.util.ArrayList<>();
		}
		this.deserializationBlackList.add(value);
		return (T) this;
	}

	/**
	 * A list of class names (separated by whitespaces) that are black-listed to
	 * be used in serialization of JMS ObjectMessage.
	 */
	@SuppressWarnings("unchecked")
	public T deserializationBlackList(String... args) {
		deserializationBlackList(Arrays.stream(args).collect(
				Collectors.toList()));
		return (T) this;
	}

	/**
	 * A list of class names (separated by whitespaces) that are white-listed to
	 * be used in serialization of JMS ObjectMessage.
	 */
	@ModelNodeBinding(detypedName = "deserialization-white-list")
	public List<String> deserializationWhiteList() {
		return this.deserializationWhiteList;
	}

	/**
	 * A list of class names (separated by whitespaces) that are white-listed to
	 * be used in serialization of JMS ObjectMessage.
	 */
	@SuppressWarnings("unchecked")
	public T deserializationWhiteList(java.util.List<String> value) {
		Object oldValue = this.deserializationWhiteList;
		this.deserializationWhiteList = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deserializationWhiteList", oldValue,
					value);
		return (T) this;
	}

	/**
	 * A list of class names (separated by whitespaces) that are white-listed to
	 * be used in serialization of JMS ObjectMessage.
	 */
	@SuppressWarnings("unchecked")
	public T deserializationWhiteList(String value) {
		if (this.deserializationWhiteList == null) {
			this.deserializationWhiteList = new java.util.ArrayList<>();
		}
		this.deserializationWhiteList.add(value);
		return (T) this;
	}

	/**
	 * A list of class names (separated by whitespaces) that are white-listed to
	 * be used in serialization of JMS ObjectMessage.
	 */
	@SuppressWarnings("unchecked")
	public T deserializationWhiteList(String... args) {
		deserializationWhiteList(Arrays.stream(args).collect(
				Collectors.toList()));
		return (T) this;
	}

	/**
	 * The discovery group name.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The discovery group name.
	 */
	@SuppressWarnings("unchecked")
	public T discoveryGroup(java.lang.String value) {
		Object oldValue = this.discoveryGroup;
		this.discoveryGroup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("discoveryGroup", oldValue, value);
		return (T) this;
	}

	/**
	 * The dups ok batch size.
	 */
	@ModelNodeBinding(detypedName = "dups-ok-batch-size")
	public Integer dupsOkBatchSize() {
		return this.dupsOkBatchSize;
	}

	/**
	 * The dups ok batch size.
	 */
	@SuppressWarnings("unchecked")
	public T dupsOkBatchSize(java.lang.Integer value) {
		Object oldValue = this.dupsOkBatchSize;
		this.dupsOkBatchSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dupsOkBatchSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Enables IronJacamar to record enlistment traces for this
	 * pooled-connection-factory. This attribute is undefined by default and the
	 * behaviour is driven by the presence of the
	 * ironjacamar.disable_enlistment_trace system property.
	 */
	@ModelNodeBinding(detypedName = "enlistment-trace")
	public Boolean enlistmentTrace() {
		return this.enlistmentTrace;
	}

	/**
	 * Enables IronJacamar to record enlistment traces for this
	 * pooled-connection-factory. This attribute is undefined by default and the
	 * behaviour is driven by the presence of the
	 * ironjacamar.disable_enlistment_trace system property.
	 */
	@SuppressWarnings("unchecked")
	public T enlistmentTrace(java.lang.Boolean value) {
		Object oldValue = this.enlistmentTrace;
		this.enlistmentTrace = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enlistmentTrace", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(java.util.List<String> value) {
		Object oldValue = this.entries;
		this.entries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("entries", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entry(String value) {
		if (this.entries == null) {
			this.entries = new java.util.ArrayList<>();
		}
		this.entries.add(value);
		return (T) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(String... args) {
		entries(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@ModelNodeBinding(detypedName = "failover-on-initial-connection")
	public Boolean failoverOnInitialConnection() {
		return this.failoverOnInitialConnection;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@SuppressWarnings("unchecked")
	public T failoverOnInitialConnection(java.lang.Boolean value) {
		Object oldValue = this.failoverOnInitialConnection;
		this.failoverOnInitialConnection = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failoverOnInitialConnection",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The group id.
	 */
	@ModelNodeBinding(detypedName = "group-id")
	public String groupId() {
		return this.groupId;
	}

	/**
	 * The group id.
	 */
	@SuppressWarnings("unchecked")
	public T groupId(java.lang.String value) {
		Object oldValue = this.groupId;
		this.groupId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("groupId", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@ModelNodeBinding(detypedName = "ha")
	public Boolean ha() {
		return this.ha;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@SuppressWarnings("unchecked")
	public T ha(java.lang.Boolean value) {
		Object oldValue = this.ha;
		this.ha = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ha", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of attempts to connect initially with this factory.
	 */
	@ModelNodeBinding(detypedName = "initial-connect-attempts")
	public Integer initialConnectAttempts() {
		return this.initialConnectAttempts;
	}

	/**
	 * The number of attempts to connect initially with this factory.
	 */
	@SuppressWarnings("unchecked")
	public T initialConnectAttempts(java.lang.Integer value) {
		Object oldValue = this.initialConnectAttempts;
		this.initialConnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialConnectAttempts", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The initial size of messages created through this factory.
	 */
	@ModelNodeBinding(detypedName = "initial-message-packet-size")
	public Integer initialMessagePacketSize() {
		return this.initialMessagePacketSize;
	}

	/**
	 * The initial size of messages created through this factory.
	 */
	@SuppressWarnings("unchecked")
	public T initialMessagePacketSize(java.lang.Integer value) {
		Object oldValue = this.initialMessagePacketSize;
		this.initialMessagePacketSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialMessagePacketSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The JNDI params to use for locating the destination for incoming
	 * connections.
	 */
	@ModelNodeBinding(detypedName = "jndi-params")
	public String jndiParams() {
		return this.jndiParams;
	}

	/**
	 * The JNDI params to use for locating the destination for incoming
	 * connections.
	 */
	@SuppressWarnings("unchecked")
	public T jndiParams(java.lang.String value) {
		Object oldValue = this.jndiParams;
		this.jndiParams = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiParams", oldValue, value);
		return (T) this;
	}

	/**
	 * The class name of the managed connection pool used by this
	 * pooled-connection-factory.
	 */
	@ModelNodeBinding(detypedName = "managed-connection-pool")
	public String managedConnectionPool() {
		return this.managedConnectionPool;
	}

	/**
	 * The class name of the managed connection pool used by this
	 * pooled-connection-factory.
	 */
	@SuppressWarnings("unchecked")
	public T managedConnectionPool(java.lang.String value) {
		Object oldValue = this.managedConnectionPool;
		this.managedConnectionPool = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managedConnectionPool", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum size for the pool
	 */
	@ModelNodeBinding(detypedName = "max-pool-size")
	public Integer maxPoolSize() {
		return this.maxPoolSize;
	}

	/**
	 * The maximum size for the pool
	 */
	@SuppressWarnings("unchecked")
	public T maxPoolSize(java.lang.Integer value) {
		Object oldValue = this.maxPoolSize;
		this.maxPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The max retry interval.
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The max retry interval.
	 */
	@SuppressWarnings("unchecked")
	public T maxRetryInterval(java.lang.Long value) {
		Object oldValue = this.maxRetryInterval;
		this.maxRetryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRetryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The min large message size.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The min large message size.
	 */
	@SuppressWarnings("unchecked")
	public T minLargeMessageSize(java.lang.Integer value) {
		Object oldValue = this.minLargeMessageSize;
		this.minLargeMessageSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minLargeMessageSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The minimum size for the pool
	 */
	@ModelNodeBinding(detypedName = "min-pool-size")
	public Integer minPoolSize() {
		return this.minPoolSize;
	}

	/**
	 * The minimum size for the pool
	 */
	@SuppressWarnings("unchecked")
	public T minPoolSize(java.lang.Integer value) {
		Object oldValue = this.minPoolSize;
		this.minPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The default password to use with this connection factory. This is only
	 * needed when pointing the connection factory to a remote host.
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * The default password to use with this connection factory. This is only
	 * needed when pointing the connection factory to a remote host.
	 */
	@SuppressWarnings("unchecked")
	public T password(java.lang.String value) {
		Object oldValue = this.password;
		this.password = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("password", oldValue, value);
		return (T) this;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@ModelNodeBinding(detypedName = "pre-acknowledge")
	public Boolean preAcknowledge() {
		return this.preAcknowledge;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public T preAcknowledge(java.lang.Boolean value) {
		Object oldValue = this.preAcknowledge;
		this.preAcknowledge = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("preAcknowledge", oldValue, value);
		return (T) this;
	}

	/**
	 * The producer max rate.
	 */
	@ModelNodeBinding(detypedName = "producer-max-rate")
	public Integer producerMaxRate() {
		return this.producerMaxRate;
	}

	/**
	 * The producer max rate.
	 */
	@SuppressWarnings("unchecked")
	public T producerMaxRate(java.lang.Integer value) {
		Object oldValue = this.producerMaxRate;
		this.producerMaxRate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("producerMaxRate", oldValue, value);
		return (T) this;
	}

	/**
	 * The producer window size.
	 */
	@ModelNodeBinding(detypedName = "producer-window-size")
	public Integer producerWindowSize() {
		return this.producerWindowSize;
	}

	/**
	 * The producer window size.
	 */
	@SuppressWarnings("unchecked")
	public T producerWindowSize(java.lang.Integer value) {
		Object oldValue = this.producerWindowSize;
		this.producerWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("producerWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The protocol manager factory used by this pooled connection factory.
	 */
	@ModelNodeBinding(detypedName = "protocol-manager-factory")
	public String protocolManagerFactory() {
		return this.protocolManagerFactory;
	}

	/**
	 * The protocol manager factory used by this pooled connection factory.
	 */
	@SuppressWarnings("unchecked")
	public T protocolManagerFactory(java.lang.String value) {
		Object oldValue = this.protocolManagerFactory;
		this.protocolManagerFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocolManagerFactory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Rebalance inbound connections when cluster topology changes.
	 */
	@ModelNodeBinding(detypedName = "rebalance-connections")
	public Boolean rebalanceConnections() {
		return this.rebalanceConnections;
	}

	/**
	 * Rebalance inbound connections when cluster topology changes.
	 */
	@SuppressWarnings("unchecked")
	public T rebalanceConnections(java.lang.Boolean value) {
		Object oldValue = this.rebalanceConnections;
		this.rebalanceConnections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rebalanceConnections", oldValue, value);
		return (T) this;
	}

	/**
	 * The reconnect attempts. By default, a pooled connection factory will try
	 * to reconnect infinitely to the messaging server(s).
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The reconnect attempts. By default, a pooled connection factory will try
	 * to reconnect infinitely to the messaging server(s).
	 */
	@SuppressWarnings("unchecked")
	public T reconnectAttempts(java.lang.Integer value) {
		Object oldValue = this.reconnectAttempts;
		this.reconnectAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reconnectAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * The retry interval.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The retry interval.
	 */
	@SuppressWarnings("unchecked")
	public T retryInterval(java.lang.Long value) {
		Object oldValue = this.retryInterval;
		this.retryInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("retryInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The retry interval multiplier.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public Double retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * The retry interval multiplier.
	 */
	@SuppressWarnings("unchecked")
	public T retryIntervalMultiplier(java.lang.Double value) {
		Object oldValue = this.retryIntervalMultiplier;
		this.retryIntervalMultiplier = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("retryIntervalMultiplier", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public T scheduledThreadPoolMaxSize(java.lang.Integer value) {
		Object oldValue = this.scheduledThreadPoolMaxSize;
		this.scheduledThreadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scheduledThreadPoolMaxSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of times to set up an MDB endpoint
	 */
	@ModelNodeBinding(detypedName = "setup-attempts")
	public Integer setupAttempts() {
		return this.setupAttempts;
	}

	/**
	 * The number of times to set up an MDB endpoint
	 */
	@SuppressWarnings("unchecked")
	public T setupAttempts(java.lang.Integer value) {
		Object oldValue = this.setupAttempts;
		this.setupAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("setupAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * The interval between attempts at setting up an MDB endpoint.
	 */
	@ModelNodeBinding(detypedName = "setup-interval")
	public Long setupInterval() {
		return this.setupInterval;
	}

	/**
	 * The interval between attempts at setting up an MDB endpoint.
	 */
	@SuppressWarnings("unchecked")
	public T setupInterval(java.lang.Long value) {
		Object oldValue = this.setupInterval;
		this.setupInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("setupInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * Define whether runtime statistics are enabled.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Define whether runtime statistics are enabled.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolMaxSize(java.lang.Integer value) {
		Object oldValue = this.threadPoolMaxSize;
		this.threadPoolMaxSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadPoolMaxSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The type of transaction supported by this pooled connection factory (can
	 * be LOCAL, NONE or XA, default is XA).
	 */
	@ModelNodeBinding(detypedName = "transaction")
	public String transaction() {
		return this.transaction;
	}

	/**
	 * The type of transaction supported by this pooled connection factory (can
	 * be LOCAL, NONE or XA, default is XA).
	 */
	@SuppressWarnings("unchecked")
	public T transaction(java.lang.String value) {
		Object oldValue = this.transaction;
		this.transaction = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transaction", oldValue, value);
		return (T) this;
	}

	/**
	 * The transaction batch size.
	 */
	@ModelNodeBinding(detypedName = "transaction-batch-size")
	public Integer transactionBatchSize() {
		return this.transactionBatchSize;
	}

	/**
	 * The transaction batch size.
	 */
	@SuppressWarnings("unchecked")
	public T transactionBatchSize(java.lang.Integer value) {
		Object oldValue = this.transactionBatchSize;
		this.transactionBatchSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transactionBatchSize", oldValue, value);
		return (T) this;
	}

	/**
	 * True to use auto recovery.
	 */
	@ModelNodeBinding(detypedName = "use-auto-recovery")
	public Boolean useAutoRecovery() {
		return this.useAutoRecovery;
	}

	/**
	 * True to use auto recovery.
	 */
	@SuppressWarnings("unchecked")
	public T useAutoRecovery(java.lang.Boolean value) {
		Object oldValue = this.useAutoRecovery;
		this.useAutoRecovery = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useAutoRecovery", oldValue, value);
		return (T) this;
	}

	/**
	 * True to use global pools.
	 */
	@ModelNodeBinding(detypedName = "use-global-pools")
	public Boolean useGlobalPools() {
		return this.useGlobalPools;
	}

	/**
	 * True to use global pools.
	 */
	@SuppressWarnings("unchecked")
	public T useGlobalPools(java.lang.Boolean value) {
		Object oldValue = this.useGlobalPools;
		this.useGlobalPools = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useGlobalPools", oldValue, value);
		return (T) this;
	}

	/**
	 * Use JNDI to locate the destination for incoming connections
	 */
	@ModelNodeBinding(detypedName = "use-jndi")
	public Boolean useJndi() {
		return this.useJndi;
	}

	/**
	 * Use JNDI to locate the destination for incoming connections
	 */
	@SuppressWarnings("unchecked")
	public T useJndi(java.lang.Boolean value) {
		Object oldValue = this.useJndi;
		this.useJndi = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useJndi", oldValue, value);
		return (T) this;
	}

	/**
	 * Use a local transaction for incoming sessions
	 */
	@ModelNodeBinding(detypedName = "use-local-tx")
	public Boolean useLocalTx() {
		return this.useLocalTx;
	}

	/**
	 * Use a local transaction for incoming sessions
	 */
	@SuppressWarnings("unchecked")
	public T useLocalTx(java.lang.Boolean value) {
		Object oldValue = this.useLocalTx;
		this.useLocalTx = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useLocalTx", oldValue, value);
		return (T) this;
	}

	/**
	 * The default username to use with this connection factory. This is only
	 * needed when pointing the connection factory to a remote host.
	 */
	@ModelNodeBinding(detypedName = "user")
	public String user() {
		return this.user;
	}

	/**
	 * The default username to use with this connection factory. This is only
	 * needed when pointing the connection factory to a remote host.
	 */
	@SuppressWarnings("unchecked")
	public T user(java.lang.String value) {
		Object oldValue = this.user;
		this.user = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("user", oldValue, value);
		return (T) this;
	}
}