package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A broadcast group is the means by which a server broadcasts connectors over
 * the network.
 */
@Address("/subsystem=messaging-activemq/server=*/broadcast-group=*")
@ResourceType("broadcast-group")
public class BroadcastGroup<T extends BroadcastGroup<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The period in milliseconds between consecutive broadcasts.")
	private Long broadcastPeriod;
	@AttributeDocumentation("Specifies the names of connectors that will be broadcast.")
	private List<String> connectors;
	@AttributeDocumentation("References the name of a JGroups channel.  If undefined, the default channel will be used.")
	private String jgroupsChannel;
	@AttributeDocumentation("The logical cluster name.")
	private String jgroupsCluster;
	@AttributeDocumentation("The broadcast group socket binding.")
	private String socketBinding;
	@AttributeDocumentation("Whether the broadcast group is started.")
	private Boolean started;

	public BroadcastGroup(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The period in milliseconds between consecutive broadcasts.
	 */
	@ModelNodeBinding(detypedName = "broadcast-period")
	public Long broadcastPeriod() {
		return this.broadcastPeriod;
	}

	/**
	 * The period in milliseconds between consecutive broadcasts.
	 */
	@SuppressWarnings("unchecked")
	public T broadcastPeriod(java.lang.Long value) {
		Object oldValue = this.broadcastPeriod;
		this.broadcastPeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("broadcastPeriod", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(java.util.List<String> value) {
		Object oldValue = this.connectors;
		this.connectors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectors", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@SuppressWarnings("unchecked")
	public T connector(String value) {
		if (this.connectors == null) {
			this.connectors = new java.util.ArrayList<>();
		}
		this.connectors.add(value);
		return (T) this;
	}

	/**
	 * Specifies the names of connectors that will be broadcast.
	 */
	@SuppressWarnings("unchecked")
	public T connectors(String... args) {
		connectors(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * References the name of a JGroups channel. If undefined, the default
	 * channel will be used.
	 */
	@ModelNodeBinding(detypedName = "jgroups-channel")
	public String jgroupsChannel() {
		return this.jgroupsChannel;
	}

	/**
	 * References the name of a JGroups channel. If undefined, the default
	 * channel will be used.
	 */
	@SuppressWarnings("unchecked")
	public T jgroupsChannel(java.lang.String value) {
		Object oldValue = this.jgroupsChannel;
		this.jgroupsChannel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jgroupsChannel", oldValue, value);
		return (T) this;
	}

	/**
	 * The logical cluster name.
	 */
	@ModelNodeBinding(detypedName = "jgroups-cluster")
	public String jgroupsCluster() {
		return this.jgroupsCluster;
	}

	/**
	 * The logical cluster name.
	 */
	@SuppressWarnings("unchecked")
	public T jgroupsCluster(java.lang.String value) {
		Object oldValue = this.jgroupsCluster;
		this.jgroupsCluster = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jgroupsCluster", oldValue, value);
		return (T) this;
	}

	/**
	 * The broadcast group socket binding.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The broadcast group socket binding.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the broadcast group is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether the broadcast group is started.
	 */
	@SuppressWarnings("unchecked")
	public T started(java.lang.Boolean value) {
		Object oldValue = this.started;
		this.started = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("started", oldValue, value);
		return (T) this;
	}
}