package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.JMSQueue;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JMSQueueConsumer<T extends JMSQueue<T>> {

	/**
	 * Configure a pre-constructed instance of JMSQueue resource
	 * 
	 * @parameter Instance of JMSQueue to configure
	 * @return nothing
	 */
	void accept(T value);

	default JMSQueueConsumer<T> andThen(JMSQueueConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}