package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.SharedStoreSlaveHAPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SharedStoreSlaveHAPolicyConsumer<T extends SharedStoreSlaveHAPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of SharedStoreSlaveHAPolicy resource
	 * 
	 * @parameter Instance of SharedStoreSlaveHAPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default SharedStoreSlaveHAPolicyConsumer<T> andThen(
			SharedStoreSlaveHAPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}