package org.wildfly.swarm.config.modcluster;

import org.wildfly.swarm.config.modcluster.Proxy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ProxyConsumer<T extends Proxy<T>> {

	/**
	 * Configure a pre-constructed instance of Proxy resource
	 * 
	 * @parameter Instance of Proxy to configure
	 * @return nothing
	 */
	void accept(T value);

	default ProxyConsumer<T> andThen(ProxyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}