package org.wildfly.swarm.config.modcluster.proxy;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration and runtime operations for mod_cluster subsystem.
 */
@Address("/subsystem=modcluster/proxy=*/ssl=configuration")
@ResourceType("ssl")
@Implicit
public class ConfigurationSsl<T extends ConfigurationSsl<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Certificate authority.")
	private String caCertificateFile;
	@AttributeDocumentation("Certificate authority revocation list.")
	private String caRevocationUrl;
	@AttributeDocumentation("Key file for the certificate.")
	private String certificateKeyFile;
	@AttributeDocumentation("Comma separated list of encryption ciphers the configuration is allowed to use.")
	private String cipherSuite;
	@AttributeDocumentation("The alias of the key holding the client certificates in the key store.")
	private String keyAlias;
	@AttributeDocumentation("Password granting access to the key store and trust store.")
	private String password;
	@AttributeDocumentation("The SSL protocols that are enabled.")
	private String protocol;

	public ConfigurationSsl() {
		super();
		this.key = "configuration";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Certificate authority.
	 */
	@ModelNodeBinding(detypedName = "ca-certificate-file")
	public String caCertificateFile() {
		return this.caCertificateFile;
	}

	/**
	 * Certificate authority.
	 */
	@SuppressWarnings("unchecked")
	public T caCertificateFile(java.lang.String value) {
		Object oldValue = this.caCertificateFile;
		this.caCertificateFile = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("caCertificateFile", oldValue, value);
		return (T) this;
	}

	/**
	 * Certificate authority revocation list.
	 */
	@ModelNodeBinding(detypedName = "ca-revocation-url")
	public String caRevocationUrl() {
		return this.caRevocationUrl;
	}

	/**
	 * Certificate authority revocation list.
	 */
	@SuppressWarnings("unchecked")
	public T caRevocationUrl(java.lang.String value) {
		Object oldValue = this.caRevocationUrl;
		this.caRevocationUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("caRevocationUrl", oldValue, value);
		return (T) this;
	}

	/**
	 * Key file for the certificate.
	 */
	@ModelNodeBinding(detypedName = "certificate-key-file")
	public String certificateKeyFile() {
		return this.certificateKeyFile;
	}

	/**
	 * Key file for the certificate.
	 */
	@SuppressWarnings("unchecked")
	public T certificateKeyFile(java.lang.String value) {
		Object oldValue = this.certificateKeyFile;
		this.certificateKeyFile = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("certificateKeyFile", oldValue, value);
		return (T) this;
	}

	/**
	 * Comma separated list of encryption ciphers the configuration is allowed
	 * to use.
	 */
	@ModelNodeBinding(detypedName = "cipher-suite")
	public String cipherSuite() {
		return this.cipherSuite;
	}

	/**
	 * Comma separated list of encryption ciphers the configuration is allowed
	 * to use.
	 */
	@SuppressWarnings("unchecked")
	public T cipherSuite(java.lang.String value) {
		Object oldValue = this.cipherSuite;
		this.cipherSuite = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cipherSuite", oldValue, value);
		return (T) this;
	}

	/**
	 * The alias of the key holding the client certificates in the key store.
	 */
	@ModelNodeBinding(detypedName = "key-alias")
	public String keyAlias() {
		return this.keyAlias;
	}

	/**
	 * The alias of the key holding the client certificates in the key store.
	 */
	@SuppressWarnings("unchecked")
	public T keyAlias(java.lang.String value) {
		Object oldValue = this.keyAlias;
		this.keyAlias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyAlias", oldValue, value);
		return (T) this;
	}

	/**
	 * Password granting access to the key store and trust store.
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * Password granting access to the key store and trust store.
	 */
	@SuppressWarnings("unchecked")
	public T password(java.lang.String value) {
		Object oldValue = this.password;
		this.password = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("password", oldValue, value);
		return (T) this;
	}

	/**
	 * The SSL protocols that are enabled.
	 */
	@ModelNodeBinding(detypedName = "protocol")
	public String protocol() {
		return this.protocol;
	}

	/**
	 * The SSL protocols that are enabled.
	 */
	@SuppressWarnings("unchecked")
	public T protocol(java.lang.String value) {
		Object oldValue = this.protocol;
		this.protocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocol", oldValue, value);
		return (T) this;
	}
}