package org.wildfly.swarm.config.modcluster.proxy;

import org.wildfly.swarm.config.modcluster.proxy.DynamicLoadProvider;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface DynamicLoadProviderConsumer<T extends DynamicLoadProvider<T>> {

	/**
	 * Configure a pre-constructed instance of DynamicLoadProvider resource
	 * 
	 * @parameter Instance of DynamicLoadProvider to configure
	 * @return nothing
	 */
	void accept(T value);

	default DynamicLoadProviderConsumer<T> andThen(
			DynamicLoadProviderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}