package org.wildfly.swarm.config.modcluster.proxy;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Simple load provider returns constant pre-configured load balancing factor.
 */
@Address("/subsystem=modcluster/proxy=*/load-provider=simple")
@ResourceType("load-provider")
@Implicit
public class SimpleLoadProvider<T extends SimpleLoadProvider<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Dynamic load provider computes the load balance factor of a node from a defined set of load metrics.")
	private Integer factor;

	public SimpleLoadProvider() {
		super();
		this.key = "simple";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Dynamic load provider computes the load balance factor of a node from a
	 * defined set of load metrics.
	 */
	@ModelNodeBinding(detypedName = "factor")
	public Integer factor() {
		return this.factor;
	}

	/**
	 * Dynamic load provider computes the load balance factor of a node from a
	 * defined set of load metrics.
	 */
	@SuppressWarnings("unchecked")
	public T factor(java.lang.Integer value) {
		Object oldValue = this.factor;
		this.factor = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("factor", oldValue, value);
		return (T) this;
	}
}