package org.wildfly.swarm.config.modcluster.proxy;

import org.wildfly.swarm.config.modcluster.proxy.SimpleLoadProvider;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SimpleLoadProviderConsumer<T extends SimpleLoadProvider<T>> {

	/**
	 * Configure a pre-constructed instance of SimpleLoadProvider resource
	 * 
	 * @parameter Instance of SimpleLoadProvider to configure
	 * @return nothing
	 */
	void accept(T value);

	default SimpleLoadProviderConsumer<T> andThen(
			SimpleLoadProviderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}