package org.wildfly.swarm.config.modcluster.proxy.load_provider;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Built-in load metric contributing a value to the overall load factor of a
 * node. The load factors from each metric are aggregated according to their
 * weights.
 */
@Address("/subsystem=modcluster/proxy=*/load-provider=dynamic/custom-load-metric=*")
@ResourceType("custom-load-metric")
public class CustomLoadMetric<T extends CustomLoadMetric<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Maximum capacity of the metric used to normalize the load values from a metric which require explicit capacity.")
	private Double capacity;
	@AttributeDocumentation("Class name to use to construct a load metric from.")
	private String attributeClass;
	@AttributeDocumentation("Module name from which to load the load metric class.")
	private String module;
	@AttributeDocumentation("Properties to apply on a loaded metric instance.")
	private Map property;
	@AttributeDocumentation("Number indicating the significance of a metric with respect to the other metrics. For example, a metric of weight 2 will have twice the impact on the overall load factor than a metric of weight 1.")
	private Integer weight;

	public CustomLoadMetric(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Maximum capacity of the metric used to normalize the load values from a
	 * metric which require explicit capacity.
	 */
	@ModelNodeBinding(detypedName = "capacity")
	public Double capacity() {
		return this.capacity;
	}

	/**
	 * Maximum capacity of the metric used to normalize the load values from a
	 * metric which require explicit capacity.
	 */
	@SuppressWarnings("unchecked")
	public T capacity(java.lang.Double value) {
		Object oldValue = this.capacity;
		this.capacity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacity", oldValue, value);
		return (T) this;
	}

	/**
	 * Class name to use to construct a load metric from.
	 */
	@ModelNodeBinding(detypedName = "class")
	public String attributeClass() {
		return this.attributeClass;
	}

	/**
	 * Class name to use to construct a load metric from.
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(java.lang.String value) {
		Object oldValue = this.attributeClass;
		this.attributeClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeClass", oldValue, value);
		return (T) this;
	}

	/**
	 * Module name from which to load the load metric class.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Module name from which to load the load metric class.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to apply on a loaded metric instance.
	 */
	@ModelNodeBinding(detypedName = "property")
	public Map property() {
		return this.property;
	}

	/**
	 * Properties to apply on a loaded metric instance.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.util.Map value) {
		Object oldValue = this.property;
		this.property = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("property", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to apply on a loaded metric instance.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.property == null) {
			this.property = new java.util.HashMap<>();
		}
		this.property.put(key, value);
		return (T) this;
	}

	/**
	 * Number indicating the significance of a metric with respect to the other
	 * metrics. For example, a metric of weight 2 will have twice the impact on
	 * the overall load factor than a metric of weight 1.
	 */
	@ModelNodeBinding(detypedName = "weight")
	public Integer weight() {
		return this.weight;
	}

	/**
	 * Number indicating the significance of a metric with respect to the other
	 * metrics. For example, a metric of weight 2 will have twice the impact on
	 * the overall load factor than a metric of weight 1.
	 */
	@SuppressWarnings("unchecked")
	public T weight(java.lang.Integer value) {
		Object oldValue = this.weight;
		this.weight = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("weight", oldValue, value);
		return (T) this;
	}
}