package org.wildfly.swarm.config.modcluster.proxy.load_provider;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;

/**
 * Built-in load metric contributing a value to the overall load factor of a
 * node. The load factors from each metric are aggregated according to their
 * weights.
 */
@Address("/subsystem=modcluster/proxy=*/load-provider=dynamic/load-metric=*")
@ResourceType("load-metric")
public class LoadMetric<T extends LoadMetric<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Maximum capacity of the metric used to normalize the load values from a metric which require explicit capacity.")
	private Double capacity;
	@AttributeDocumentation("Properties to apply on a loaded metric instance.")
	private Map property;
	@AttributeDocumentation("Type of a built-in load metric from the enumerated values.")
	private Type type;
	@AttributeDocumentation("Number indicating the significance of a metric with respect to the other metrics. For example, a metric of weight 2 will have twice the impact on the overall load factor than a metric of weight 1.")
	private Integer weight;

	public LoadMetric(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public static enum Type {
		CPU("cpu"), MEM("mem"), HEAP("heap"), SESSIONS("sessions"), RECEIVE_TRAFFIC(
				"receive-traffic"), SEND_TRAFFIC("send-traffic"), REQUESTS(
				"requests"), BUSYNESS("busyness");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		Type(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Maximum capacity of the metric used to normalize the load values from a
	 * metric which require explicit capacity.
	 */
	@ModelNodeBinding(detypedName = "capacity")
	public Double capacity() {
		return this.capacity;
	}

	/**
	 * Maximum capacity of the metric used to normalize the load values from a
	 * metric which require explicit capacity.
	 */
	@SuppressWarnings("unchecked")
	public T capacity(java.lang.Double value) {
		Object oldValue = this.capacity;
		this.capacity = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacity", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to apply on a loaded metric instance.
	 */
	@ModelNodeBinding(detypedName = "property")
	public Map property() {
		return this.property;
	}

	/**
	 * Properties to apply on a loaded metric instance.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.util.Map value) {
		Object oldValue = this.property;
		this.property = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("property", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to apply on a loaded metric instance.
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.property == null) {
			this.property = new java.util.HashMap<>();
		}
		this.property.put(key, value);
		return (T) this;
	}

	/**
	 * Type of a built-in load metric from the enumerated values.
	 */
	@ModelNodeBinding(detypedName = "type")
	public Type type() {
		return this.type;
	}

	/**
	 * Type of a built-in load metric from the enumerated values.
	 */
	@SuppressWarnings("unchecked")
	public T type(Type value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}

	/**
	 * Number indicating the significance of a metric with respect to the other
	 * metrics. For example, a metric of weight 2 will have twice the impact on
	 * the overall load factor than a metric of weight 1.
	 */
	@ModelNodeBinding(detypedName = "weight")
	public Integer weight() {
		return this.weight;
	}

	/**
	 * Number indicating the significance of a metric with respect to the other
	 * metrics. For example, a metric of weight 2 will have twice the impact on
	 * the overall load factor than a metric of weight 1.
	 */
	@SuppressWarnings("unchecked")
	public T weight(java.lang.Integer value) {
		Object oldValue = this.weight;
		this.weight = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("weight", oldValue, value);
		return (T) this;
	}
}