package org.wildfly.swarm.config.resource.adapters.resource_adapter;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigPropertiesConsumer;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigPropertiesSupplier;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigProperties;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;

/**
 * Specifies a connection definition.
 */
@Address("/subsystem=resource-adapters/resource-adapter=*/connection-definitions=*")
@ResourceType("connection-definitions")
public class ConnectionDefinitions<T extends ConnectionDefinitions<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ConnectionDefinitionsResources subresources = new ConnectionDefinitionsResources();
	@AttributeDocumentation("The allocation retry element indicates the number of times that allocating a connection should be tried before throwing an exception.")
	private Integer allocationRetry;
	@AttributeDocumentation("The allocation retry wait millis element specifies the amount of time, in milliseconds, to wait between retrying to allocate a connection.")
	private Long allocationRetryWaitMillis;
	@AttributeDocumentation("The Elytron authentication context which defines the javax.security.auth.Subject that is used to distinguish connections in the pool.")
	private String authenticationContext;
	@AttributeDocumentation("Indicates that either application-supplied parameters, such as from getConnection(user, pw), or Subject (provided by Elytron after authenticating using configured authentication-context), are used to distinguish connections in the pool.")
	private String authenticationContextAndApplication;
	@AttributeDocumentation("An element to specify that connections should be validated on a background thread versus being validated prior to use. Changing this value requires a server restart.")
	private Boolean backgroundValidation;
	@AttributeDocumentation("The background-validation-millis element specifies the amount of time, in milliseconds, that background validation will run. Changing this value requires a server restart.")
	private Long backgroundValidationMillis;
	@AttributeDocumentation("The blocking-timeout-millis element specifies the maximum time, in milliseconds, to block while waiting for a connection before throwing an exception. Note that this blocks only while waiting for locking a connection, and will never throw an exception if creating a new connection takes an inordinately long time.")
	private Long blockingTimeoutWaitMillis;
	@AttributeDocumentation("Class defining the policy for decrementing connections in the pool.")
	private String capacityDecrementerClass;
	@AttributeDocumentation("Properties to inject in class defining the policy for decrementing connections in the pool.")
	private Map capacityDecrementerProperties;
	@AttributeDocumentation("Class defining the policy for incrementing connections in the pool.")
	private String capacityIncrementerClass;
	@AttributeDocumentation("Properties to inject in class defining the policy for incrementing connections in the pool.")
	private Map capacityIncrementerProperties;
	@AttributeDocumentation("Specifies the fully qualified class name of a managed connection factory or admin object.")
	private String className;
	@AttributeDocumentation("Enable the use of CMR. This feature means that a local resource can reliably participate in an XA transaction.")
	private Boolean connectable;
	@AttributeDocumentation("Enables Elytron security for handling authentication of connections. The Elytron authentication-context to be used will be current context if no context is specified (see authentication-context).")
	private Boolean elytronEnabled;
	@AttributeDocumentation("Specifies if the resource adapter should be enabled.")
	private Boolean enabled;
	@AttributeDocumentation("Defines if lazy enlistment should be used if supported by the resource adapter.")
	private Boolean enlistment;
	@AttributeDocumentation("Defines if WildFly/IronJacamar should record enlistment traces.")
	private Boolean enlistmentTrace;
	@AttributeDocumentation("Specifies how the pool should be flushed in case of an error.")
	private FlushStrategy flushStrategy;
	@AttributeDocumentation("Specifies the maximum time, in minutes, a connection may be idle before being closed. The actual maximum time depends also on the IdleRemover scan time, which is half of the smallest idle-timeout-minutes value of any pool. Changing this value requires a server restart.")
	private Long idleTimeoutMinutes;
	@AttributeDocumentation("Specifies the initial number of connections a pool should hold.")
	private Integer initialPoolSize;
	@AttributeDocumentation("An element to enable interleaving for XA connections.")
	private Boolean interleaving;
	@AttributeDocumentation("Specifies the JNDI name for the connection factory.")
	private String jndiName;
	@AttributeDocumentation("Specifies the maximum number of connections for a pool. No more connections will be created in each sub-pool.")
	private Integer maxPoolSize;
	@AttributeDocumentation("Defines the ManagedConnectionPool implementation. For example: org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool.")
	private String mcp;
	@AttributeDocumentation("Specifies the minimum number of connections for a pool.")
	private Integer minPoolSize;
	@AttributeDocumentation("Specifies if the connection pool should be excluded from recovery.")
	private Boolean noRecovery;
	@AttributeDocumentation("Oracle does not like XA connections getting used both inside and outside a JTA transaction. To workaround the problem you can create separate sub-pools for the different contexts.")
	private Boolean noTxSeparatePool;
	@AttributeDocumentation("Specifies whether the Xid should be padded.")
	private Boolean padXid;
	@AttributeDocumentation("Defines if pool use should be fair.")
	private Boolean poolFair;
	@AttributeDocumentation("Specifies if the pool should be prefilled. Changing this value requires a server restart.")
	private Boolean poolPrefill;
	@AttributeDocumentation("Specifies if the min-pool-size should be considered strict.")
	private Boolean poolUseStrictMin;
	@AttributeDocumentation("The Elytron authentication context used for recovery (current authentication-context will be used if unspecified).")
	private String recoveryAuthenticationContext;
	@AttributeDocumentation("Credential (from Credential Store) to authenticate on recovery connection")
	private Map recoveryCredentialReference;
	@AttributeDocumentation("Indicates that an Elytron authentication context will be used for recovery.")
	private Boolean recoveryElytronEnabled;
	@AttributeDocumentation("The password used for recovery.")
	private String recoveryPassword;
	@AttributeDocumentation("The fully qualified class name of the recovery plugin implementation.")
	private String recoveryPluginClassName;
	@AttributeDocumentation("The properties for the recovery plugin.")
	private Map recoveryPluginProperties;
	@AttributeDocumentation("The PicketBox security domain used for recovery.")
	private String recoverySecurityDomain;
	@AttributeDocumentation("The user name used for recovery.")
	private String recoveryUsername;
	@AttributeDocumentation("Using this attribute, you can unconditionally set whether javax.transaction.xa.XAResource.isSameRM(XAResource) returns true or false.")
	private Boolean sameRmOverride;
	@AttributeDocumentation("Indicates that application-supplied parameters, such as from getConnection(user, pw), are used to distinguish connections in the pool.")
	private Boolean securityApplication;
	@AttributeDocumentation("Specifies the PicketBox security domain which defines the javax.security.auth.Subject that is used to distinguish connections in the pool.")
	private String securityDomain;
	@AttributeDocumentation("Indicates that either application-supplied parameters, such as from getConnection(user, pw), or Subject (from PicketBox security domain), are used to distinguish connections in the pool.")
	private String securityDomainAndApplication;
	@AttributeDocumentation("Enable the use of sharable connections, which allows lazy association to be enabled if supported.")
	private Boolean sharable;
	@AttributeDocumentation("Defines if IronJacamar should track connection handles across transaction boundaries.")
	private Boolean tracking;
	@AttributeDocumentation("Enable the use of a cached connection manager.")
	private Boolean useCcm;
	@AttributeDocumentation("Whether to fail a connection allocation on the first try if it is invalid (true) or keep trying until the pool is exhausted of all potential connections (false).")
	private Boolean useFastFail;
	@AttributeDocumentation("Setting this to false will bind the object into global JNDI.")
	private Boolean useJavaContext;
	@AttributeDocumentation("This specifies if connection validation should be done when a connection factory attempts to match a managed connection. This is typically exclusive to the use of background validation.")
	private Boolean validateOnMatch;
	@AttributeDocumentation("Specifies whether XAResource instances should be wrapped in an org.jboss.tm.XAResourceWrapper instance.")
	private Boolean wrapXaResource;
	@AttributeDocumentation("The value is passed to XAResource.setTransactionTimeout(), in seconds.")
	private Integer xaResourceTimeout;

	public ConnectionDefinitions(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ConnectionDefinitionsResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ConfigProperties objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConfigProperties objects.
	 */
	@SuppressWarnings("unchecked")
	public T configProperties(java.util.List<ConfigProperties> value) {
		this.subresources.configProperties = value;
		return (T) this;
	}

	/**
	 * Add the ConfigProperties object to the list of subresources
	 * 
	 * @param value
	 *            The ConfigProperties to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configProperties(ConfigProperties value) {
		this.subresources.configProperties.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigProperties object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConfigProperties resource
	 * @param config
	 *            The ConfigPropertiesConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configProperties(java.lang.String childKey,
			ConfigPropertiesConsumer consumer) {
		ConfigProperties<? extends ConfigProperties> child = new ConfigProperties<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		configProperties(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConfigProperties object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConfigProperties resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T configProperties(java.lang.String childKey) {
		configProperties(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConfigProperties object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T configProperties(ConfigPropertiesSupplier supplier) {
		configProperties(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ConnectionDefinitions
	 */
	public static class ConnectionDefinitionsResources {
		/**
		 * A custom defined config property.
		 */
		@ResourceDocumentation("A custom defined config property.")
		@SubresourceInfo("configProperties")
		private List<ConfigProperties> configProperties = new java.util.ArrayList<>();

		/**
		 * Get the list of ConfigProperties resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConfigProperties> configProperties() {
			return this.configProperties;
		}

		public ConfigProperties configProperties(java.lang.String key) {
			return this.configProperties.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	public static enum FlushStrategy {
		FAILINGCONNECTIONONLY("FailingConnectionOnly"), INVALIDIDLECONNECTIONS(
				"InvalidIdleConnections"), IDLECONNECTIONS("IdleConnections"), GRACEFULLY(
				"Gracefully"), ENTIREPOOL("EntirePool"), ALLINVALIDIDLECONNECTIONS(
				"AllInvalidIdleConnections"), ALLIDLECONNECTIONS(
				"AllIdleConnections"), ALLGRACEFULLY("AllGracefully"), ALLCONNECTIONS(
				"AllConnections");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		FlushStrategy(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The allocation retry element indicates the number of times that
	 * allocating a connection should be tried before throwing an exception.
	 */
	@ModelNodeBinding(detypedName = "allocation-retry")
	public Integer allocationRetry() {
		return this.allocationRetry;
	}

	/**
	 * The allocation retry element indicates the number of times that
	 * allocating a connection should be tried before throwing an exception.
	 */
	@SuppressWarnings("unchecked")
	public T allocationRetry(java.lang.Integer value) {
		Object oldValue = this.allocationRetry;
		this.allocationRetry = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allocationRetry", oldValue, value);
		return (T) this;
	}

	/**
	 * The allocation retry wait millis element specifies the amount of time, in
	 * milliseconds, to wait between retrying to allocate a connection.
	 */
	@ModelNodeBinding(detypedName = "allocation-retry-wait-millis")
	public Long allocationRetryWaitMillis() {
		return this.allocationRetryWaitMillis;
	}

	/**
	 * The allocation retry wait millis element specifies the amount of time, in
	 * milliseconds, to wait between retrying to allocate a connection.
	 */
	@SuppressWarnings("unchecked")
	public T allocationRetryWaitMillis(java.lang.Long value) {
		Object oldValue = this.allocationRetryWaitMillis;
		this.allocationRetryWaitMillis = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allocationRetryWaitMillis", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The Elytron authentication context which defines the
	 * javax.security.auth.Subject that is used to distinguish connections in
	 * the pool.
	 */
	@ModelNodeBinding(detypedName = "authentication-context")
	public String authenticationContext() {
		return this.authenticationContext;
	}

	/**
	 * The Elytron authentication context which defines the
	 * javax.security.auth.Subject that is used to distinguish connections in
	 * the pool.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContext(java.lang.String value) {
		Object oldValue = this.authenticationContext;
		this.authenticationContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationContext", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Indicates that either application-supplied parameters, such as from
	 * getConnection(user, pw), or Subject (provided by Elytron after
	 * authenticating using configured authentication-context), are used to
	 * distinguish connections in the pool.
	 */
	@ModelNodeBinding(detypedName = "authentication-context-and-application")
	public String authenticationContextAndApplication() {
		return this.authenticationContextAndApplication;
	}

	/**
	 * Indicates that either application-supplied parameters, such as from
	 * getConnection(user, pw), or Subject (provided by Elytron after
	 * authenticating using configured authentication-context), are used to
	 * distinguish connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContextAndApplication(java.lang.String value) {
		Object oldValue = this.authenticationContextAndApplication;
		this.authenticationContextAndApplication = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationContextAndApplication",
					oldValue, value);
		return (T) this;
	}

	/**
	 * An element to specify that connections should be validated on a
	 * background thread versus being validated prior to use. Changing this
	 * value requires a server restart.
	 */
	@ModelNodeBinding(detypedName = "background-validation")
	public Boolean backgroundValidation() {
		return this.backgroundValidation;
	}

	/**
	 * An element to specify that connections should be validated on a
	 * background thread versus being validated prior to use. Changing this
	 * value requires a server restart.
	 */
	@SuppressWarnings("unchecked")
	public T backgroundValidation(java.lang.Boolean value) {
		Object oldValue = this.backgroundValidation;
		this.backgroundValidation = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("backgroundValidation", oldValue, value);
		return (T) this;
	}

	/**
	 * The background-validation-millis element specifies the amount of time, in
	 * milliseconds, that background validation will run. Changing this value
	 * requires a server restart.
	 */
	@ModelNodeBinding(detypedName = "background-validation-millis")
	public Long backgroundValidationMillis() {
		return this.backgroundValidationMillis;
	}

	/**
	 * The background-validation-millis element specifies the amount of time, in
	 * milliseconds, that background validation will run. Changing this value
	 * requires a server restart.
	 */
	@SuppressWarnings("unchecked")
	public T backgroundValidationMillis(java.lang.Long value) {
		Object oldValue = this.backgroundValidationMillis;
		this.backgroundValidationMillis = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("backgroundValidationMillis", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The blocking-timeout-millis element specifies the maximum time, in
	 * milliseconds, to block while waiting for a connection before throwing an
	 * exception. Note that this blocks only while waiting for locking a
	 * connection, and will never throw an exception if creating a new
	 * connection takes an inordinately long time.
	 */
	@ModelNodeBinding(detypedName = "blocking-timeout-wait-millis")
	public Long blockingTimeoutWaitMillis() {
		return this.blockingTimeoutWaitMillis;
	}

	/**
	 * The blocking-timeout-millis element specifies the maximum time, in
	 * milliseconds, to block while waiting for a connection before throwing an
	 * exception. Note that this blocks only while waiting for locking a
	 * connection, and will never throw an exception if creating a new
	 * connection takes an inordinately long time.
	 */
	@SuppressWarnings("unchecked")
	public T blockingTimeoutWaitMillis(java.lang.Long value) {
		Object oldValue = this.blockingTimeoutWaitMillis;
		this.blockingTimeoutWaitMillis = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("blockingTimeoutWaitMillis", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Class defining the policy for decrementing connections in the pool.
	 */
	@ModelNodeBinding(detypedName = "capacity-decrementer-class")
	public String capacityDecrementerClass() {
		return this.capacityDecrementerClass;
	}

	/**
	 * Class defining the policy for decrementing connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T capacityDecrementerClass(java.lang.String value) {
		Object oldValue = this.capacityDecrementerClass;
		this.capacityDecrementerClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityDecrementerClass", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Properties to inject in class defining the policy for decrementing
	 * connections in the pool.
	 */
	@ModelNodeBinding(detypedName = "capacity-decrementer-properties")
	public Map capacityDecrementerProperties() {
		return this.capacityDecrementerProperties;
	}

	/**
	 * Properties to inject in class defining the policy for decrementing
	 * connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T capacityDecrementerProperties(java.util.Map value) {
		Object oldValue = this.capacityDecrementerProperties;
		this.capacityDecrementerProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityDecrementerProperties",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to inject in class defining the policy for decrementing
	 * connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T capacityDecrementerProperty(java.lang.String key,
			java.lang.Object value) {
		if (this.capacityDecrementerProperties == null) {
			this.capacityDecrementerProperties = new java.util.HashMap<>();
		}
		this.capacityDecrementerProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Class defining the policy for incrementing connections in the pool.
	 */
	@ModelNodeBinding(detypedName = "capacity-incrementer-class")
	public String capacityIncrementerClass() {
		return this.capacityIncrementerClass;
	}

	/**
	 * Class defining the policy for incrementing connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T capacityIncrementerClass(java.lang.String value) {
		Object oldValue = this.capacityIncrementerClass;
		this.capacityIncrementerClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityIncrementerClass", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Properties to inject in class defining the policy for incrementing
	 * connections in the pool.
	 */
	@ModelNodeBinding(detypedName = "capacity-incrementer-properties")
	public Map capacityIncrementerProperties() {
		return this.capacityIncrementerProperties;
	}

	/**
	 * Properties to inject in class defining the policy for incrementing
	 * connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T capacityIncrementerProperties(java.util.Map value) {
		Object oldValue = this.capacityIncrementerProperties;
		this.capacityIncrementerProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityIncrementerProperties",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to inject in class defining the policy for incrementing
	 * connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T capacityIncrementerProperty(java.lang.String key,
			java.lang.Object value) {
		if (this.capacityIncrementerProperties == null) {
			this.capacityIncrementerProperties = new java.util.HashMap<>();
		}
		this.capacityIncrementerProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Specifies the fully qualified class name of a managed connection factory
	 * or admin object.
	 */
	@ModelNodeBinding(detypedName = "class-name")
	public String className() {
		return this.className;
	}

	/**
	 * Specifies the fully qualified class name of a managed connection factory
	 * or admin object.
	 */
	@SuppressWarnings("unchecked")
	public T className(java.lang.String value) {
		Object oldValue = this.className;
		this.className = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("className", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable the use of CMR. This feature means that a local resource can
	 * reliably participate in an XA transaction.
	 */
	@ModelNodeBinding(detypedName = "connectable")
	public Boolean connectable() {
		return this.connectable;
	}

	/**
	 * Enable the use of CMR. This feature means that a local resource can
	 * reliably participate in an XA transaction.
	 */
	@SuppressWarnings("unchecked")
	public T connectable(java.lang.Boolean value) {
		Object oldValue = this.connectable;
		this.connectable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectable", oldValue, value);
		return (T) this;
	}

	/**
	 * Enables Elytron security for handling authentication of connections. The
	 * Elytron authentication-context to be used will be current context if no
	 * context is specified (see authentication-context).
	 */
	@ModelNodeBinding(detypedName = "elytron-enabled")
	public Boolean elytronEnabled() {
		return this.elytronEnabled;
	}

	/**
	 * Enables Elytron security for handling authentication of connections. The
	 * Elytron authentication-context to be used will be current context if no
	 * context is specified (see authentication-context).
	 */
	@SuppressWarnings("unchecked")
	public T elytronEnabled(java.lang.Boolean value) {
		Object oldValue = this.elytronEnabled;
		this.elytronEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("elytronEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies if the resource adapter should be enabled.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specifies if the resource adapter should be enabled.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(java.lang.Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines if lazy enlistment should be used if supported by the resource
	 * adapter.
	 */
	@ModelNodeBinding(detypedName = "enlistment")
	public Boolean enlistment() {
		return this.enlistment;
	}

	/**
	 * Defines if lazy enlistment should be used if supported by the resource
	 * adapter.
	 */
	@SuppressWarnings("unchecked")
	public T enlistment(java.lang.Boolean value) {
		Object oldValue = this.enlistment;
		this.enlistment = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enlistment", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines if WildFly/IronJacamar should record enlistment traces.
	 */
	@ModelNodeBinding(detypedName = "enlistment-trace")
	public Boolean enlistmentTrace() {
		return this.enlistmentTrace;
	}

	/**
	 * Defines if WildFly/IronJacamar should record enlistment traces.
	 */
	@SuppressWarnings("unchecked")
	public T enlistmentTrace(java.lang.Boolean value) {
		Object oldValue = this.enlistmentTrace;
		this.enlistmentTrace = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enlistmentTrace", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies how the pool should be flushed in case of an error.
	 */
	@ModelNodeBinding(detypedName = "flush-strategy")
	public FlushStrategy flushStrategy() {
		return this.flushStrategy;
	}

	/**
	 * Specifies how the pool should be flushed in case of an error.
	 */
	@SuppressWarnings("unchecked")
	public T flushStrategy(FlushStrategy value) {
		Object oldValue = this.flushStrategy;
		this.flushStrategy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("flushStrategy", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the maximum time, in minutes, a connection may be idle before
	 * being closed. The actual maximum time depends also on the IdleRemover
	 * scan time, which is half of the smallest idle-timeout-minutes value of
	 * any pool. Changing this value requires a server restart.
	 */
	@ModelNodeBinding(detypedName = "idle-timeout-minutes")
	public Long idleTimeoutMinutes() {
		return this.idleTimeoutMinutes;
	}

	/**
	 * Specifies the maximum time, in minutes, a connection may be idle before
	 * being closed. The actual maximum time depends also on the IdleRemover
	 * scan time, which is half of the smallest idle-timeout-minutes value of
	 * any pool. Changing this value requires a server restart.
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeoutMinutes(java.lang.Long value) {
		Object oldValue = this.idleTimeoutMinutes;
		this.idleTimeoutMinutes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idleTimeoutMinutes", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the initial number of connections a pool should hold.
	 */
	@ModelNodeBinding(detypedName = "initial-pool-size")
	public Integer initialPoolSize() {
		return this.initialPoolSize;
	}

	/**
	 * Specifies the initial number of connections a pool should hold.
	 */
	@SuppressWarnings("unchecked")
	public T initialPoolSize(java.lang.Integer value) {
		Object oldValue = this.initialPoolSize;
		this.initialPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * An element to enable interleaving for XA connections.
	 */
	@ModelNodeBinding(detypedName = "interleaving")
	public Boolean interleaving() {
		return this.interleaving;
	}

	/**
	 * An element to enable interleaving for XA connections.
	 */
	@SuppressWarnings("unchecked")
	public T interleaving(java.lang.Boolean value) {
		Object oldValue = this.interleaving;
		this.interleaving = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("interleaving", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the JNDI name for the connection factory.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * Specifies the JNDI name for the connection factory.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(java.lang.String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the maximum number of connections for a pool. No more
	 * connections will be created in each sub-pool.
	 */
	@ModelNodeBinding(detypedName = "max-pool-size")
	public Integer maxPoolSize() {
		return this.maxPoolSize;
	}

	/**
	 * Specifies the maximum number of connections for a pool. No more
	 * connections will be created in each sub-pool.
	 */
	@SuppressWarnings("unchecked")
	public T maxPoolSize(java.lang.Integer value) {
		Object oldValue = this.maxPoolSize;
		this.maxPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the ManagedConnectionPool implementation. For example:
	 * org.jboss.jca
	 * .core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool.
	 */
	@ModelNodeBinding(detypedName = "mcp")
	public String mcp() {
		return this.mcp;
	}

	/**
	 * Defines the ManagedConnectionPool implementation. For example:
	 * org.jboss.jca
	 * .core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool.
	 */
	@SuppressWarnings("unchecked")
	public T mcp(java.lang.String value) {
		Object oldValue = this.mcp;
		this.mcp = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mcp", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the minimum number of connections for a pool.
	 */
	@ModelNodeBinding(detypedName = "min-pool-size")
	public Integer minPoolSize() {
		return this.minPoolSize;
	}

	/**
	 * Specifies the minimum number of connections for a pool.
	 */
	@SuppressWarnings("unchecked")
	public T minPoolSize(java.lang.Integer value) {
		Object oldValue = this.minPoolSize;
		this.minPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies if the connection pool should be excluded from recovery.
	 */
	@ModelNodeBinding(detypedName = "no-recovery")
	public Boolean noRecovery() {
		return this.noRecovery;
	}

	/**
	 * Specifies if the connection pool should be excluded from recovery.
	 */
	@SuppressWarnings("unchecked")
	public T noRecovery(java.lang.Boolean value) {
		Object oldValue = this.noRecovery;
		this.noRecovery = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("noRecovery", oldValue, value);
		return (T) this;
	}

	/**
	 * Oracle does not like XA connections getting used both inside and outside
	 * a JTA transaction. To workaround the problem you can create separate
	 * sub-pools for the different contexts.
	 */
	@ModelNodeBinding(detypedName = "no-tx-separate-pool")
	public Boolean noTxSeparatePool() {
		return this.noTxSeparatePool;
	}

	/**
	 * Oracle does not like XA connections getting used both inside and outside
	 * a JTA transaction. To workaround the problem you can create separate
	 * sub-pools for the different contexts.
	 */
	@SuppressWarnings("unchecked")
	public T noTxSeparatePool(java.lang.Boolean value) {
		Object oldValue = this.noTxSeparatePool;
		this.noTxSeparatePool = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("noTxSeparatePool", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies whether the Xid should be padded.
	 */
	@ModelNodeBinding(detypedName = "pad-xid")
	public Boolean padXid() {
		return this.padXid;
	}

	/**
	 * Specifies whether the Xid should be padded.
	 */
	@SuppressWarnings("unchecked")
	public T padXid(java.lang.Boolean value) {
		Object oldValue = this.padXid;
		this.padXid = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("padXid", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines if pool use should be fair.
	 */
	@ModelNodeBinding(detypedName = "pool-fair")
	public Boolean poolFair() {
		return this.poolFair;
	}

	/**
	 * Defines if pool use should be fair.
	 */
	@SuppressWarnings("unchecked")
	public T poolFair(java.lang.Boolean value) {
		Object oldValue = this.poolFair;
		this.poolFair = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("poolFair", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies if the pool should be prefilled. Changing this value requires a
	 * server restart.
	 */
	@ModelNodeBinding(detypedName = "pool-prefill")
	public Boolean poolPrefill() {
		return this.poolPrefill;
	}

	/**
	 * Specifies if the pool should be prefilled. Changing this value requires a
	 * server restart.
	 */
	@SuppressWarnings("unchecked")
	public T poolPrefill(java.lang.Boolean value) {
		Object oldValue = this.poolPrefill;
		this.poolPrefill = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("poolPrefill", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies if the min-pool-size should be considered strict.
	 */
	@ModelNodeBinding(detypedName = "pool-use-strict-min")
	public Boolean poolUseStrictMin() {
		return this.poolUseStrictMin;
	}

	/**
	 * Specifies if the min-pool-size should be considered strict.
	 */
	@SuppressWarnings("unchecked")
	public T poolUseStrictMin(java.lang.Boolean value) {
		Object oldValue = this.poolUseStrictMin;
		this.poolUseStrictMin = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("poolUseStrictMin", oldValue, value);
		return (T) this;
	}

	/**
	 * The Elytron authentication context used for recovery (current
	 * authentication-context will be used if unspecified).
	 */
	@ModelNodeBinding(detypedName = "recovery-authentication-context")
	public String recoveryAuthenticationContext() {
		return this.recoveryAuthenticationContext;
	}

	/**
	 * The Elytron authentication context used for recovery (current
	 * authentication-context will be used if unspecified).
	 */
	@SuppressWarnings("unchecked")
	public T recoveryAuthenticationContext(java.lang.String value) {
		Object oldValue = this.recoveryAuthenticationContext;
		this.recoveryAuthenticationContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoveryAuthenticationContext",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate on recovery connection
	 */
	@ModelNodeBinding(detypedName = "recovery-credential-reference")
	public Map recoveryCredentialReference() {
		return this.recoveryCredentialReference;
	}

	/**
	 * Credential (from Credential Store) to authenticate on recovery connection
	 */
	@SuppressWarnings("unchecked")
	public T recoveryCredentialReference(java.util.Map value) {
		Object oldValue = this.recoveryCredentialReference;
		this.recoveryCredentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoveryCredentialReference",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate on recovery connection
	 */
	@SuppressWarnings("unchecked")
	public T recoveryCredentialReference(java.lang.String key,
			java.lang.Object value) {
		if (this.recoveryCredentialReference == null) {
			this.recoveryCredentialReference = new java.util.HashMap<>();
		}
		this.recoveryCredentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * Indicates that an Elytron authentication context will be used for
	 * recovery.
	 */
	@ModelNodeBinding(detypedName = "recovery-elytron-enabled")
	public Boolean recoveryElytronEnabled() {
		return this.recoveryElytronEnabled;
	}

	/**
	 * Indicates that an Elytron authentication context will be used for
	 * recovery.
	 */
	@SuppressWarnings("unchecked")
	public T recoveryElytronEnabled(java.lang.Boolean value) {
		Object oldValue = this.recoveryElytronEnabled;
		this.recoveryElytronEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoveryElytronEnabled", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The password used for recovery.
	 */
	@ModelNodeBinding(detypedName = "recovery-password")
	public String recoveryPassword() {
		return this.recoveryPassword;
	}

	/**
	 * The password used for recovery.
	 */
	@SuppressWarnings("unchecked")
	public T recoveryPassword(java.lang.String value) {
		Object oldValue = this.recoveryPassword;
		this.recoveryPassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoveryPassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The fully qualified class name of the recovery plugin implementation.
	 */
	@ModelNodeBinding(detypedName = "recovery-plugin-class-name")
	public String recoveryPluginClassName() {
		return this.recoveryPluginClassName;
	}

	/**
	 * The fully qualified class name of the recovery plugin implementation.
	 */
	@SuppressWarnings("unchecked")
	public T recoveryPluginClassName(java.lang.String value) {
		Object oldValue = this.recoveryPluginClassName;
		this.recoveryPluginClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoveryPluginClassName", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The properties for the recovery plugin.
	 */
	@ModelNodeBinding(detypedName = "recovery-plugin-properties")
	public Map recoveryPluginProperties() {
		return this.recoveryPluginProperties;
	}

	/**
	 * The properties for the recovery plugin.
	 */
	@SuppressWarnings("unchecked")
	public T recoveryPluginProperties(java.util.Map value) {
		Object oldValue = this.recoveryPluginProperties;
		this.recoveryPluginProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoveryPluginProperties", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The properties for the recovery plugin.
	 */
	@SuppressWarnings("unchecked")
	public T recoveryPluginProperty(java.lang.String key, java.lang.Object value) {
		if (this.recoveryPluginProperties == null) {
			this.recoveryPluginProperties = new java.util.HashMap<>();
		}
		this.recoveryPluginProperties.put(key, value);
		return (T) this;
	}

	/**
	 * The PicketBox security domain used for recovery.
	 */
	@ModelNodeBinding(detypedName = "recovery-security-domain")
	public String recoverySecurityDomain() {
		return this.recoverySecurityDomain;
	}

	/**
	 * The PicketBox security domain used for recovery.
	 */
	@SuppressWarnings("unchecked")
	public T recoverySecurityDomain(java.lang.String value) {
		Object oldValue = this.recoverySecurityDomain;
		this.recoverySecurityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoverySecurityDomain", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The user name used for recovery.
	 */
	@ModelNodeBinding(detypedName = "recovery-username")
	public String recoveryUsername() {
		return this.recoveryUsername;
	}

	/**
	 * The user name used for recovery.
	 */
	@SuppressWarnings("unchecked")
	public T recoveryUsername(java.lang.String value) {
		Object oldValue = this.recoveryUsername;
		this.recoveryUsername = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoveryUsername", oldValue, value);
		return (T) this;
	}

	/**
	 * Using this attribute, you can unconditionally set whether
	 * javax.transaction.xa.XAResource.isSameRM(XAResource) returns true or
	 * false.
	 */
	@ModelNodeBinding(detypedName = "same-rm-override")
	public Boolean sameRmOverride() {
		return this.sameRmOverride;
	}

	/**
	 * Using this attribute, you can unconditionally set whether
	 * javax.transaction.xa.XAResource.isSameRM(XAResource) returns true or
	 * false.
	 */
	@SuppressWarnings("unchecked")
	public T sameRmOverride(java.lang.Boolean value) {
		Object oldValue = this.sameRmOverride;
		this.sameRmOverride = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sameRmOverride", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates that application-supplied parameters, such as from
	 * getConnection(user, pw), are used to distinguish connections in the pool.
	 */
	@ModelNodeBinding(detypedName = "security-application")
	public Boolean securityApplication() {
		return this.securityApplication;
	}

	/**
	 * Indicates that application-supplied parameters, such as from
	 * getConnection(user, pw), are used to distinguish connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T securityApplication(java.lang.Boolean value) {
		Object oldValue = this.securityApplication;
		this.securityApplication = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityApplication", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the PicketBox security domain which defines the
	 * javax.security.auth.Subject that is used to distinguish connections in
	 * the pool.
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * Specifies the PicketBox security domain which defines the
	 * javax.security.auth.Subject that is used to distinguish connections in
	 * the pool.
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}

	/**
	 * Indicates that either application-supplied parameters, such as from
	 * getConnection(user, pw), or Subject (from PicketBox security domain), are
	 * used to distinguish connections in the pool.
	 */
	@ModelNodeBinding(detypedName = "security-domain-and-application")
	public String securityDomainAndApplication() {
		return this.securityDomainAndApplication;
	}

	/**
	 * Indicates that either application-supplied parameters, such as from
	 * getConnection(user, pw), or Subject (from PicketBox security domain), are
	 * used to distinguish connections in the pool.
	 */
	@SuppressWarnings("unchecked")
	public T securityDomainAndApplication(java.lang.String value) {
		Object oldValue = this.securityDomainAndApplication;
		this.securityDomainAndApplication = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomainAndApplication",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Enable the use of sharable connections, which allows lazy association to
	 * be enabled if supported.
	 */
	@ModelNodeBinding(detypedName = "sharable")
	public Boolean sharable() {
		return this.sharable;
	}

	/**
	 * Enable the use of sharable connections, which allows lazy association to
	 * be enabled if supported.
	 */
	@SuppressWarnings("unchecked")
	public T sharable(java.lang.Boolean value) {
		Object oldValue = this.sharable;
		this.sharable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sharable", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines if IronJacamar should track connection handles across transaction
	 * boundaries.
	 */
	@ModelNodeBinding(detypedName = "tracking")
	public Boolean tracking() {
		return this.tracking;
	}

	/**
	 * Defines if IronJacamar should track connection handles across transaction
	 * boundaries.
	 */
	@SuppressWarnings("unchecked")
	public T tracking(java.lang.Boolean value) {
		Object oldValue = this.tracking;
		this.tracking = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tracking", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable the use of a cached connection manager.
	 */
	@ModelNodeBinding(detypedName = "use-ccm")
	public Boolean useCcm() {
		return this.useCcm;
	}

	/**
	 * Enable the use of a cached connection manager.
	 */
	@SuppressWarnings("unchecked")
	public T useCcm(java.lang.Boolean value) {
		Object oldValue = this.useCcm;
		this.useCcm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useCcm", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to fail a connection allocation on the first try if it is invalid
	 * (true) or keep trying until the pool is exhausted of all potential
	 * connections (false).
	 */
	@ModelNodeBinding(detypedName = "use-fast-fail")
	public Boolean useFastFail() {
		return this.useFastFail;
	}

	/**
	 * Whether to fail a connection allocation on the first try if it is invalid
	 * (true) or keep trying until the pool is exhausted of all potential
	 * connections (false).
	 */
	@SuppressWarnings("unchecked")
	public T useFastFail(java.lang.Boolean value) {
		Object oldValue = this.useFastFail;
		this.useFastFail = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useFastFail", oldValue, value);
		return (T) this;
	}

	/**
	 * Setting this to false will bind the object into global JNDI.
	 */
	@ModelNodeBinding(detypedName = "use-java-context")
	public Boolean useJavaContext() {
		return this.useJavaContext;
	}

	/**
	 * Setting this to false will bind the object into global JNDI.
	 */
	@SuppressWarnings("unchecked")
	public T useJavaContext(java.lang.Boolean value) {
		Object oldValue = this.useJavaContext;
		this.useJavaContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useJavaContext", oldValue, value);
		return (T) this;
	}

	/**
	 * This specifies if connection validation should be done when a connection
	 * factory attempts to match a managed connection. This is typically
	 * exclusive to the use of background validation.
	 */
	@ModelNodeBinding(detypedName = "validate-on-match")
	public Boolean validateOnMatch() {
		return this.validateOnMatch;
	}

	/**
	 * This specifies if connection validation should be done when a connection
	 * factory attempts to match a managed connection. This is typically
	 * exclusive to the use of background validation.
	 */
	@SuppressWarnings("unchecked")
	public T validateOnMatch(java.lang.Boolean value) {
		Object oldValue = this.validateOnMatch;
		this.validateOnMatch = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("validateOnMatch", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies whether XAResource instances should be wrapped in an
	 * org.jboss.tm.XAResourceWrapper instance.
	 */
	@ModelNodeBinding(detypedName = "wrap-xa-resource")
	public Boolean wrapXaResource() {
		return this.wrapXaResource;
	}

	/**
	 * Specifies whether XAResource instances should be wrapped in an
	 * org.jboss.tm.XAResourceWrapper instance.
	 */
	@SuppressWarnings("unchecked")
	public T wrapXaResource(java.lang.Boolean value) {
		Object oldValue = this.wrapXaResource;
		this.wrapXaResource = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("wrapXaResource", oldValue, value);
		return (T) this;
	}

	/**
	 * The value is passed to XAResource.setTransactionTimeout(), in seconds.
	 */
	@ModelNodeBinding(detypedName = "xa-resource-timeout")
	public Integer xaResourceTimeout() {
		return this.xaResourceTimeout;
	}

	/**
	 * The value is passed to XAResource.setTransactionTimeout(), in seconds.
	 */
	@SuppressWarnings("unchecked")
	public T xaResourceTimeout(java.lang.Integer value) {
		Object oldValue = this.xaResourceTimeout;
		this.xaResourceTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("xaResourceTimeout", oldValue, value);
		return (T) this;
	}
}