package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.security.ElytronTrustManager;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ElytronTrustManagerConsumer<T extends ElytronTrustManager<T>> {

	/**
	 * Configure a pre-constructed instance of ElytronTrustManager resource
	 * 
	 * @parameter Instance of ElytronTrustManager to configure
	 * @return nothing
	 */
	void accept(T value);

	default ElytronTrustManagerConsumer<T> andThen(
			ElytronTrustManagerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}