package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.ClassicJSSE;
import org.wildfly.swarm.config.security.security_domain.ClassicJSSEConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicJSSESupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthorization;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthorizationConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthorizationSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicAudit;
import org.wildfly.swarm.config.security.security_domain.ClassicAuditConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicAuditSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicACL;
import org.wildfly.swarm.config.security.security_domain.ClassicACLConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicACLSupplier;
import org.wildfly.swarm.config.security.security_domain.JaspiAuthentication;
import org.wildfly.swarm.config.security.security_domain.JaspiAuthenticationConsumer;
import org.wildfly.swarm.config.security.security_domain.JaspiAuthenticationSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicMapping;
import org.wildfly.swarm.config.security.security_domain.ClassicMappingConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicMappingSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicIdentityTrust;
import org.wildfly.swarm.config.security.security_domain.ClassicIdentityTrustConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicIdentityTrustSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthentication;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthenticationConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthenticationSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * Configures a security domain. Authentication, authorization, ACL, mapping,
 * auditing and identity trust are configured here.
 */
@Address("/subsystem=security/security-domain=*")
@ResourceType("security-domain")
public class SecurityDomain<T extends SecurityDomain<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private SecurityDomainResources subresources = new SecurityDomainResources();
	@AttributeDocumentation("Adds a cache to speed up authentication checks. Allowed values are 'default' to use simple map as the cache and 'infinispan' to use an Infinispan cache.")
	private CacheType cacheType;

	public SecurityDomain(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SecurityDomainResources subresources() {
		return this.subresources;
	}

	/**
	 * JSSE configuration. Configures attributes for keystores that can be used
	 * for setting up SSL.
	 */
	@SuppressWarnings("unchecked")
	public T classicJsse(ClassicJSSE value) {
		this.subresources.classicJsse = value;
		return (T) this;
	}

	/**
	 * JSSE configuration. Configures attributes for keystores that can be used
	 * for setting up SSL.
	 */
	@SuppressWarnings("unchecked")
	public T classicJsse(ClassicJSSEConsumer consumer) {
		ClassicJSSE<? extends ClassicJSSE> child = new ClassicJSSE<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.classicJsse = child;
		return (T) this;
	}

	/**
	 * JSSE configuration. Configures attributes for keystores that can be used
	 * for setting up SSL.
	 */
	@SuppressWarnings("unchecked")
	public T classicJsse() {
		ClassicJSSE<? extends ClassicJSSE> child = new ClassicJSSE<>();
		this.subresources.classicJsse = child;
		return (T) this;
	}

	/**
	 * JSSE configuration. Configures attributes for keystores that can be used
	 * for setting up SSL.
	 */
	@SuppressWarnings("unchecked")
	public T classicJsse(ClassicJSSESupplier supplier) {
		this.subresources.classicJsse = supplier.get();
		return (T) this;
	}

	/**
	 * Authorization configuration. Configures a list of authorization policy
	 * modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAuthorization(ClassicAuthorization value) {
		this.subresources.classicAuthorization = value;
		return (T) this;
	}

	/**
	 * Authorization configuration. Configures a list of authorization policy
	 * modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAuthorization(ClassicAuthorizationConsumer consumer) {
		ClassicAuthorization<? extends ClassicAuthorization> child = new ClassicAuthorization<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.classicAuthorization = child;
		return (T) this;
	}

	/**
	 * Authorization configuration. Configures a list of authorization policy
	 * modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAuthorization() {
		ClassicAuthorization<? extends ClassicAuthorization> child = new ClassicAuthorization<>();
		this.subresources.classicAuthorization = child;
		return (T) this;
	}

	/**
	 * Authorization configuration. Configures a list of authorization policy
	 * modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAuthorization(ClassicAuthorizationSupplier supplier) {
		this.subresources.classicAuthorization = supplier.get();
		return (T) this;
	}

	/**
	 * Auditing configuration. Configures a list of provider modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAudit(ClassicAudit value) {
		this.subresources.classicAudit = value;
		return (T) this;
	}

	/**
	 * Auditing configuration. Configures a list of provider modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAudit(ClassicAuditConsumer consumer) {
		ClassicAudit<? extends ClassicAudit> child = new ClassicAudit<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.classicAudit = child;
		return (T) this;
	}

	/**
	 * Auditing configuration. Configures a list of provider modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAudit() {
		ClassicAudit<? extends ClassicAudit> child = new ClassicAudit<>();
		this.subresources.classicAudit = child;
		return (T) this;
	}

	/**
	 * Auditing configuration. Configures a list of provider modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAudit(ClassicAuditSupplier supplier) {
		this.subresources.classicAudit = supplier.get();
		return (T) this;
	}

	/**
	 * Access control list configuration. Configures a list of ACL modules to be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAcl(ClassicACL value) {
		this.subresources.classicAcl = value;
		return (T) this;
	}

	/**
	 * Access control list configuration. Configures a list of ACL modules to be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAcl(ClassicACLConsumer consumer) {
		ClassicACL<? extends ClassicACL> child = new ClassicACL<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.classicAcl = child;
		return (T) this;
	}

	/**
	 * Access control list configuration. Configures a list of ACL modules to be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAcl() {
		ClassicACL<? extends ClassicACL> child = new ClassicACL<>();
		this.subresources.classicAcl = child;
		return (T) this;
	}

	/**
	 * Access control list configuration. Configures a list of ACL modules to be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAcl(ClassicACLSupplier supplier) {
		this.subresources.classicAcl = supplier.get();
		return (T) this;
	}

	/**
	 * JASPI authentication configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jaspiAuthentication(JaspiAuthentication value) {
		this.subresources.jaspiAuthentication = value;
		return (T) this;
	}

	/**
	 * JASPI authentication configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jaspiAuthentication(JaspiAuthenticationConsumer consumer) {
		JaspiAuthentication<? extends JaspiAuthentication> child = new JaspiAuthentication<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.jaspiAuthentication = child;
		return (T) this;
	}

	/**
	 * JASPI authentication configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jaspiAuthentication() {
		JaspiAuthentication<? extends JaspiAuthentication> child = new JaspiAuthentication<>();
		this.subresources.jaspiAuthentication = child;
		return (T) this;
	}

	/**
	 * JASPI authentication configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jaspiAuthentication(JaspiAuthenticationSupplier supplier) {
		this.subresources.jaspiAuthentication = supplier.get();
		return (T) this;
	}

	/**
	 * Mapping configuration. Configures a list of mapping modules to be used
	 * for principal, role, attribute and credential mapping.
	 */
	@SuppressWarnings("unchecked")
	public T classicMapping(ClassicMapping value) {
		this.subresources.classicMapping = value;
		return (T) this;
	}

	/**
	 * Mapping configuration. Configures a list of mapping modules to be used
	 * for principal, role, attribute and credential mapping.
	 */
	@SuppressWarnings("unchecked")
	public T classicMapping(ClassicMappingConsumer consumer) {
		ClassicMapping<? extends ClassicMapping> child = new ClassicMapping<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.classicMapping = child;
		return (T) this;
	}

	/**
	 * Mapping configuration. Configures a list of mapping modules to be used
	 * for principal, role, attribute and credential mapping.
	 */
	@SuppressWarnings("unchecked")
	public T classicMapping() {
		ClassicMapping<? extends ClassicMapping> child = new ClassicMapping<>();
		this.subresources.classicMapping = child;
		return (T) this;
	}

	/**
	 * Mapping configuration. Configures a list of mapping modules to be used
	 * for principal, role, attribute and credential mapping.
	 */
	@SuppressWarnings("unchecked")
	public T classicMapping(ClassicMappingSupplier supplier) {
		this.subresources.classicMapping = supplier.get();
		return (T) this;
	}

	/**
	 * Identity trust configuration. Configures a list of trust modules to be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T classicIdentityTrust(ClassicIdentityTrust value) {
		this.subresources.classicIdentityTrust = value;
		return (T) this;
	}

	/**
	 * Identity trust configuration. Configures a list of trust modules to be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T classicIdentityTrust(ClassicIdentityTrustConsumer consumer) {
		ClassicIdentityTrust<? extends ClassicIdentityTrust> child = new ClassicIdentityTrust<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.classicIdentityTrust = child;
		return (T) this;
	}

	/**
	 * Identity trust configuration. Configures a list of trust modules to be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T classicIdentityTrust() {
		ClassicIdentityTrust<? extends ClassicIdentityTrust> child = new ClassicIdentityTrust<>();
		this.subresources.classicIdentityTrust = child;
		return (T) this;
	}

	/**
	 * Identity trust configuration. Configures a list of trust modules to be
	 * used.
	 */
	@SuppressWarnings("unchecked")
	public T classicIdentityTrust(ClassicIdentityTrustSupplier supplier) {
		this.subresources.classicIdentityTrust = supplier.get();
		return (T) this;
	}

	/**
	 * Traditional authentication configuration. Configures a list of login
	 * modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAuthentication(ClassicAuthentication value) {
		this.subresources.classicAuthentication = value;
		return (T) this;
	}

	/**
	 * Traditional authentication configuration. Configures a list of login
	 * modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAuthentication(ClassicAuthenticationConsumer consumer) {
		ClassicAuthentication<? extends ClassicAuthentication> child = new ClassicAuthentication<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.classicAuthentication = child;
		return (T) this;
	}

	/**
	 * Traditional authentication configuration. Configures a list of login
	 * modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAuthentication() {
		ClassicAuthentication<? extends ClassicAuthentication> child = new ClassicAuthentication<>();
		this.subresources.classicAuthentication = child;
		return (T) this;
	}

	/**
	 * Traditional authentication configuration. Configures a list of login
	 * modules to be used.
	 */
	@SuppressWarnings("unchecked")
	public T classicAuthentication(ClassicAuthenticationSupplier supplier) {
		this.subresources.classicAuthentication = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for SecurityDomain
	 */
	public static class SecurityDomainResources {
		@SingletonResource
		@ResourceDocumentation("JSSE configuration. Configures attributes for keystores that can be used for setting up SSL.")
		private ClassicJSSE classicJsse;
		@SingletonResource
		@ResourceDocumentation("Authorization configuration. Configures a list of authorization policy modules to be used.")
		private ClassicAuthorization classicAuthorization;
		@SingletonResource
		@ResourceDocumentation("Auditing configuration. Configures a list of provider modules to be used.")
		private ClassicAudit classicAudit;
		@SingletonResource
		@ResourceDocumentation("Access control list configuration. Configures a list of ACL modules to be used.")
		private ClassicACL classicAcl;
		@SingletonResource
		@ResourceDocumentation("JASPI authentication configuration.")
		private JaspiAuthentication jaspiAuthentication;
		@SingletonResource
		@ResourceDocumentation("Mapping configuration. Configures a list of mapping modules to be used for principal, role, attribute and credential mapping.")
		private ClassicMapping classicMapping;
		@SingletonResource
		@ResourceDocumentation("Identity trust configuration. Configures a list of trust modules to be used.")
		private ClassicIdentityTrust classicIdentityTrust;
		@SingletonResource
		@ResourceDocumentation("Traditional authentication configuration.  Configures a list of login modules to be used.")
		private ClassicAuthentication classicAuthentication;

		/**
		 * JSSE configuration. Configures attributes for keystores that can be
		 * used for setting up SSL.
		 */
		@Subresource
		public ClassicJSSE classicJsse() {
			return this.classicJsse;
		}

		/**
		 * Authorization configuration. Configures a list of authorization
		 * policy modules to be used.
		 */
		@Subresource
		public ClassicAuthorization classicAuthorization() {
			return this.classicAuthorization;
		}

		/**
		 * Auditing configuration. Configures a list of provider modules to be
		 * used.
		 */
		@Subresource
		public ClassicAudit classicAudit() {
			return this.classicAudit;
		}

		/**
		 * Access control list configuration. Configures a list of ACL modules
		 * to be used.
		 */
		@Subresource
		public ClassicACL classicAcl() {
			return this.classicAcl;
		}

		/**
		 * JASPI authentication configuration.
		 */
		@Subresource
		public JaspiAuthentication jaspiAuthentication() {
			return this.jaspiAuthentication;
		}

		/**
		 * Mapping configuration. Configures a list of mapping modules to be
		 * used for principal, role, attribute and credential mapping.
		 */
		@Subresource
		public ClassicMapping classicMapping() {
			return this.classicMapping;
		}

		/**
		 * Identity trust configuration. Configures a list of trust modules to
		 * be used.
		 */
		@Subresource
		public ClassicIdentityTrust classicIdentityTrust() {
			return this.classicIdentityTrust;
		}

		/**
		 * Traditional authentication configuration. Configures a list of login
		 * modules to be used.
		 */
		@Subresource
		public ClassicAuthentication classicAuthentication() {
			return this.classicAuthentication;
		}
	}

	public static enum CacheType {
		DEFAULT("default"), INFINISPAN("infinispan");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		CacheType(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * Adds a cache to speed up authentication checks. Allowed values are
	 * 'default' to use simple map as the cache and 'infinispan' to use an
	 * Infinispan cache.
	 */
	@ModelNodeBinding(detypedName = "cache-type")
	public CacheType cacheType() {
		return this.cacheType;
	}

	/**
	 * Adds a cache to speed up authentication checks. Allowed values are
	 * 'default' to use simple map as the cache and 'infinispan' to use an
	 * Infinispan cache.
	 */
	@SuppressWarnings("unchecked")
	public T cacheType(CacheType value) {
		Object oldValue = this.cacheType;
		this.cacheType = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheType", oldValue, value);
		return (T) this;
	}
}