package org.wildfly.swarm.config.security.security_domain.identity_trust;

import org.wildfly.swarm.config.security.security_domain.identity_trust.TrustModule;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TrustModuleConsumer<T extends TrustModule<T>> {

	/**
	 * Configure a pre-constructed instance of TrustModule resource
	 * 
	 * @parameter Instance of TrustModule to configure
	 * @return nothing
	 */
	void accept(T value);

	default TrustModuleConsumer<T> andThen(TrustModuleConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}