package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.application_security_domain.SingleSignOnSetting;
import org.wildfly.swarm.config.undertow.application_security_domain.SingleSignOnSettingConsumer;
import org.wildfly.swarm.config.undertow.application_security_domain.SingleSignOnSettingSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A Mapping from a security domain references in a deployed application.
 */
@Address("/subsystem=undertow/application-security-domain=*")
@ResourceType("application-security-domain")
public class ApplicationSecurityDomain<T extends ApplicationSecurityDomain<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ApplicationSecurityDomainResources subresources = new ApplicationSecurityDomainResources();
	@AttributeDocumentation("Enable authorization using JACC")
	private Boolean enableJacc;
	@AttributeDocumentation("Enable JASPI authentication for the associated deployments.")
	private Boolean enableJaspi;
	@AttributeDocumentation("The HTTP Authentication Factory to be used by deployments that reference the mapped security domain.")
	private String httpAuthenticationFactory;
	@AttributeDocumentation("Should integrated JASPI be used or allow AsHoc identity creation.")
	private Boolean integratedJaspi;
	@AttributeDocumentation("Should the authentication configuration in the deployment be overridden by the factory.")
	private Boolean overrideDeploymentConfig;
	@AttributeDocumentation("The deployments currently referencing this mapping.")
	private List<String> referencingDeployments;
	@AttributeDocumentation("The SecurityDomain to be used by deployments that reference the mapped security domain.")
	private String securityDomain;

	public ApplicationSecurityDomain(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ApplicationSecurityDomainResources subresources() {
		return this.subresources;
	}

	/**
	 * An SSO authentication mechanism configuration.
	 */
	@SuppressWarnings("unchecked")
	public T singleSignOnSetting(SingleSignOnSetting value) {
		this.subresources.singleSignOnSetting = value;
		return (T) this;
	}

	/**
	 * An SSO authentication mechanism configuration.
	 */
	@SuppressWarnings("unchecked")
	public T singleSignOnSetting(SingleSignOnSettingConsumer consumer) {
		SingleSignOnSetting<? extends SingleSignOnSetting> child = new SingleSignOnSetting<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.singleSignOnSetting = child;
		return (T) this;
	}

	/**
	 * An SSO authentication mechanism configuration.
	 */
	@SuppressWarnings("unchecked")
	public T singleSignOnSetting() {
		SingleSignOnSetting<? extends SingleSignOnSetting> child = new SingleSignOnSetting<>();
		this.subresources.singleSignOnSetting = child;
		return (T) this;
	}

	/**
	 * An SSO authentication mechanism configuration.
	 */
	@SuppressWarnings("unchecked")
	public T singleSignOnSetting(SingleSignOnSettingSupplier supplier) {
		this.subresources.singleSignOnSetting = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for ApplicationSecurityDomain
	 */
	public static class ApplicationSecurityDomainResources {
		@SingletonResource
		@ResourceDocumentation("An SSO authentication mechanism configuration.")
		private SingleSignOnSetting singleSignOnSetting;

		/**
		 * An SSO authentication mechanism configuration.
		 */
		@Subresource
		public SingleSignOnSetting singleSignOnSetting() {
			return this.singleSignOnSetting;
		}
	}

	/**
	 * Enable authorization using JACC
	 */
	@ModelNodeBinding(detypedName = "enable-jacc")
	public Boolean enableJacc() {
		return this.enableJacc;
	}

	/**
	 * Enable authorization using JACC
	 */
	@SuppressWarnings("unchecked")
	public T enableJacc(java.lang.Boolean value) {
		Object oldValue = this.enableJacc;
		this.enableJacc = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableJacc", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable JASPI authentication for the associated deployments.
	 */
	@ModelNodeBinding(detypedName = "enable-jaspi")
	public Boolean enableJaspi() {
		return this.enableJaspi;
	}

	/**
	 * Enable JASPI authentication for the associated deployments.
	 */
	@SuppressWarnings("unchecked")
	public T enableJaspi(java.lang.Boolean value) {
		Object oldValue = this.enableJaspi;
		this.enableJaspi = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableJaspi", oldValue, value);
		return (T) this;
	}

	/**
	 * The HTTP Authentication Factory to be used by deployments that reference
	 * the mapped security domain.
	 */
	@ModelNodeBinding(detypedName = "http-authentication-factory")
	public String httpAuthenticationFactory() {
		return this.httpAuthenticationFactory;
	}

	/**
	 * The HTTP Authentication Factory to be used by deployments that reference
	 * the mapped security domain.
	 */
	@SuppressWarnings("unchecked")
	public T httpAuthenticationFactory(java.lang.String value) {
		Object oldValue = this.httpAuthenticationFactory;
		this.httpAuthenticationFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpAuthenticationFactory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Should integrated JASPI be used or allow AsHoc identity creation.
	 */
	@ModelNodeBinding(detypedName = "integrated-jaspi")
	public Boolean integratedJaspi() {
		return this.integratedJaspi;
	}

	/**
	 * Should integrated JASPI be used or allow AsHoc identity creation.
	 */
	@SuppressWarnings("unchecked")
	public T integratedJaspi(java.lang.Boolean value) {
		Object oldValue = this.integratedJaspi;
		this.integratedJaspi = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("integratedJaspi", oldValue, value);
		return (T) this;
	}

	/**
	 * Should the authentication configuration in the deployment be overridden
	 * by the factory.
	 */
	@ModelNodeBinding(detypedName = "override-deployment-config")
	public Boolean overrideDeploymentConfig() {
		return this.overrideDeploymentConfig;
	}

	/**
	 * Should the authentication configuration in the deployment be overridden
	 * by the factory.
	 */
	@SuppressWarnings("unchecked")
	public T overrideDeploymentConfig(java.lang.Boolean value) {
		Object oldValue = this.overrideDeploymentConfig;
		this.overrideDeploymentConfig = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("overrideDeploymentConfig", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The deployments currently referencing this mapping.
	 */
	@ModelNodeBinding(detypedName = "referencing-deployments")
	public List<String> referencingDeployments() {
		return this.referencingDeployments;
	}

	/**
	 * The deployments currently referencing this mapping.
	 */
	@SuppressWarnings("unchecked")
	public T referencingDeployments(java.util.List<String> value) {
		Object oldValue = this.referencingDeployments;
		this.referencingDeployments = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("referencingDeployments", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The deployments currently referencing this mapping.
	 */
	@SuppressWarnings("unchecked")
	public T referencingDeployment(String value) {
		if (this.referencingDeployments == null) {
			this.referencingDeployments = new java.util.ArrayList<>();
		}
		this.referencingDeployments.add(value);
		return (T) this;
	}

	/**
	 * The deployments currently referencing this mapping.
	 */
	@SuppressWarnings("unchecked")
	public T referencingDeployments(String... args) {
		referencingDeployments(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The SecurityDomain to be used by deployments that reference the mapped
	 * security domain.
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * The SecurityDomain to be used by deployments that reference the mapped
	 * security domain.
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}
}