package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.undertow.BufferCache;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface BufferCacheConsumer<T extends BufferCache<T>> {

	/**
	 * Configure a pre-constructed instance of BufferCache resource
	 * 
	 * @parameter Instance of BufferCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default BufferCacheConsumer<T> andThen(BufferCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}