package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.undertow.FilterConfiguration;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface FilterConfigurationConsumer<T extends FilterConfiguration<T>> {

	/**
	 * Configure a pre-constructed instance of FilterConfiguration resource
	 * 
	 * @parameter Instance of FilterConfiguration to configure
	 * @return nothing
	 */
	void accept(T value);

	default FilterConfigurationConsumer<T> andThen(
			FilterConfigurationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}