package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.undertow.ServletContainer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ServletContainerConsumer<T extends ServletContainer<T>> {

	/**
	 * Configure a pre-constructed instance of ServletContainer resource
	 * 
	 * @parameter Instance of ServletContainer to configure
	 * @return nothing
	 */
	void accept(T value);

	default ServletContainerConsumer<T> andThen(
			ServletContainerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}