package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.undertow.configuration.ExpressionFilter;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ExpressionFilterConsumer<T extends ExpressionFilter<T>> {

	/**
	 * Configure a pre-constructed instance of ExpressionFilter resource
	 * 
	 * @parameter Instance of ExpressionFilter to configure
	 * @return nothing
	 */
	void accept(T value);

	default ExpressionFilterConsumer<T> andThen(
			ExpressionFilterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}