package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.NodeConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.NodeSupplier;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroupConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroupSupplier;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.LoadBalancingGroup;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Runtime representation of a mod_cluster balancer
 */
@Address("/subsystem=undertow/configuration=filter/mod-cluster=*/balancer=*")
@ResourceType("balancer")
public class Balancer<T extends Balancer<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private BalancerResources subresources = new BalancerResources();
	@AttributeDocumentation("Maximum number of failover attempts by reverse proxy when sending the request to the backend server.")
	private Integer maxAttempts;
	@AttributeDocumentation("If sticky sessions are enabled")
	private Boolean stickySession;
	@AttributeDocumentation("The session cookie name")
	private String stickySessionCookie;
	@AttributeDocumentation("If this is true then an error will be returned if the request cannot be routed to the sticky node, otherwise it will be routed to another node")
	private Boolean stickySessionForce;
	@AttributeDocumentation("The path of the sticky session cookie")
	private String stickySessionPath;
	@AttributeDocumentation("Remove the session cookie if the request cannot be routed to the correct host")
	private Boolean stickySessionRemove;
	@AttributeDocumentation("The number of seconds to wait for an available worker")
	private Integer waitWorker;

	public Balancer(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public BalancerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Node objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Node objects.
	 */
	@SuppressWarnings("unchecked")
	public T nodes(java.util.List<Node> value) {
		this.subresources.nodes = value;
		return (T) this;
	}

	/**
	 * Add the Node object to the list of subresources
	 * 
	 * @param value
	 *            The Node to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T node(Node value) {
		this.subresources.nodes.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Node object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Node resource
	 * @param config
	 *            The NodeConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T node(java.lang.String childKey, NodeConsumer consumer) {
		Node<? extends Node> child = new Node<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		node(child);
		return (T) this;
	}

	/**
	 * Create and configure a Node object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Node resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T node(java.lang.String childKey) {
		node(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Node object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T node(NodeSupplier supplier) {
		node(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LoadBalancingGroup objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LoadBalancingGroup objects.
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroups(java.util.List<LoadBalancingGroup> value) {
		this.subresources.loadBalancingGroups = value;
		return (T) this;
	}

	/**
	 * Add the LoadBalancingGroup object to the list of subresources
	 * 
	 * @param value
	 *            The LoadBalancingGroup to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroup(LoadBalancingGroup value) {
		this.subresources.loadBalancingGroups.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LoadBalancingGroup object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LoadBalancingGroup resource
	 * @param config
	 *            The LoadBalancingGroupConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroup(java.lang.String childKey,
			LoadBalancingGroupConsumer consumer) {
		LoadBalancingGroup<? extends LoadBalancingGroup> child = new LoadBalancingGroup<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		loadBalancingGroup(child);
		return (T) this;
	}

	/**
	 * Create and configure a LoadBalancingGroup object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LoadBalancingGroup resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroup(java.lang.String childKey) {
		loadBalancingGroup(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LoadBalancingGroup object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T loadBalancingGroup(LoadBalancingGroupSupplier supplier) {
		loadBalancingGroup(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for Balancer
	 */
	public static class BalancerResources {
		/**
		 * Runtime representation of a mod_cluster node
		 */
		@ResourceDocumentation("Runtime representation of a mod_cluster node")
		@SubresourceInfo("node")
		private List<Node> nodes = new java.util.ArrayList<>();
		/**
		 * A load balancing group
		 */
		@ResourceDocumentation("A load balancing group")
		@SubresourceInfo("loadBalancingGroup")
		private List<LoadBalancingGroup> loadBalancingGroups = new java.util.ArrayList<>();

		/**
		 * Get the list of Node resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Node> nodes() {
			return this.nodes;
		}

		public Node node(java.lang.String key) {
			return this.nodes.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of LoadBalancingGroup resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LoadBalancingGroup> loadBalancingGroups() {
			return this.loadBalancingGroups;
		}

		public LoadBalancingGroup loadBalancingGroup(java.lang.String key) {
			return this.loadBalancingGroups.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * Maximum number of failover attempts by reverse proxy when sending the
	 * request to the backend server.
	 */
	@ModelNodeBinding(detypedName = "max-attempts")
	public Integer maxAttempts() {
		return this.maxAttempts;
	}

	/**
	 * Maximum number of failover attempts by reverse proxy when sending the
	 * request to the backend server.
	 */
	@SuppressWarnings("unchecked")
	public T maxAttempts(java.lang.Integer value) {
		Object oldValue = this.maxAttempts;
		this.maxAttempts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxAttempts", oldValue, value);
		return (T) this;
	}

	/**
	 * If sticky sessions are enabled
	 */
	@ModelNodeBinding(detypedName = "sticky-session")
	public Boolean stickySession() {
		return this.stickySession;
	}

	/**
	 * If sticky sessions are enabled
	 */
	@SuppressWarnings("unchecked")
	public T stickySession(java.lang.Boolean value) {
		Object oldValue = this.stickySession;
		this.stickySession = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stickySession", oldValue, value);
		return (T) this;
	}

	/**
	 * The session cookie name
	 */
	@ModelNodeBinding(detypedName = "sticky-session-cookie")
	public String stickySessionCookie() {
		return this.stickySessionCookie;
	}

	/**
	 * The session cookie name
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionCookie(java.lang.String value) {
		Object oldValue = this.stickySessionCookie;
		this.stickySessionCookie = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stickySessionCookie", oldValue, value);
		return (T) this;
	}

	/**
	 * If this is true then an error will be returned if the request cannot be
	 * routed to the sticky node, otherwise it will be routed to another node
	 */
	@ModelNodeBinding(detypedName = "sticky-session-force")
	public Boolean stickySessionForce() {
		return this.stickySessionForce;
	}

	/**
	 * If this is true then an error will be returned if the request cannot be
	 * routed to the sticky node, otherwise it will be routed to another node
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionForce(java.lang.Boolean value) {
		Object oldValue = this.stickySessionForce;
		this.stickySessionForce = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stickySessionForce", oldValue, value);
		return (T) this;
	}

	/**
	 * The path of the sticky session cookie
	 */
	@ModelNodeBinding(detypedName = "sticky-session-path")
	public String stickySessionPath() {
		return this.stickySessionPath;
	}

	/**
	 * The path of the sticky session cookie
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionPath(java.lang.String value) {
		Object oldValue = this.stickySessionPath;
		this.stickySessionPath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stickySessionPath", oldValue, value);
		return (T) this;
	}

	/**
	 * Remove the session cookie if the request cannot be routed to the correct
	 * host
	 */
	@ModelNodeBinding(detypedName = "sticky-session-remove")
	public Boolean stickySessionRemove() {
		return this.stickySessionRemove;
	}

	/**
	 * Remove the session cookie if the request cannot be routed to the correct
	 * host
	 */
	@SuppressWarnings("unchecked")
	public T stickySessionRemove(java.lang.Boolean value) {
		Object oldValue = this.stickySessionRemove;
		this.stickySessionRemove = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stickySessionRemove", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of seconds to wait for an available worker
	 */
	@ModelNodeBinding(detypedName = "wait-worker")
	public Integer waitWorker() {
		return this.waitWorker;
	}

	/**
	 * The number of seconds to wait for an available worker
	 */
	@SuppressWarnings("unchecked")
	public T waitWorker(java.lang.Integer value) {
		Object oldValue = this.waitWorker;
		this.waitWorker = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("waitWorker", oldValue, value);
		return (T) this;
	}
}