package org.wildfly.swarm.config.undertow.server;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * http listener
 */
@Address("/subsystem=undertow/server=*/ajp-listener=*")
@ResourceType("ajp-listener")
public class AJPListener<T extends AJPListener<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("If a request comes in with encoded / characters (i.e. %2F), will these be decoded.")
	private Boolean allowEncodedSlash;
	@AttributeDocumentation("If this is true then Undertow will allow non-escaped equals characters in unquoted cookie values. Unquoted cookie values may not contain equals characters. If present the value ends before the equals sign. The remainder of the cookie value will be dropped.")
	private Boolean allowEqualsInCookieValue;
	@AttributeDocumentation("If this is true Undertow will accept non-encoded characters that are disallowed by the URI specification. This defaults to false, and in general should not be needed as most clients correctly encode characters. Note that setting this to true can be considered a security risk, as allowing non-standard characters can allow request smuggling attacks in some circumstances.")
	private Boolean allowUnescapedCharactersInUrl;
	@AttributeDocumentation("If this is true then a Connection: keep-alive header will be added to responses, even when it is not strictly required by the specification.")
	private Boolean alwaysSetKeepAlive;
	@AttributeDocumentation("If we should buffer pipelined requests.")
	private Boolean bufferPipelinedData;
	@AttributeDocumentation("The listeners buffer pool")
	private String bufferPool;
	@AttributeDocumentation("The number of bytes that have been received by this listener")
	private Long bytesReceived;
	@AttributeDocumentation("The number of bytes that have been sent out on this listener")
	private Long bytesSent;
	@AttributeDocumentation("If this is true then the parser will decode the URL and query parameters using the selected character encoding (UTF-8 by default). If this is false they will not be decoded. This will allow a later handler to decode them into whatever charset is desired.")
	private Boolean decodeUrl;
	@AttributeDocumentation("A comma separated list of HTTP methods that are not allowed")
	private List<String> disallowedMethods;
	@AttributeDocumentation("The number of 500 responses that have been sent by this listener")
	private Long errorCount;
	@AttributeDocumentation("The maximum supported size of AJP packets. If this is modified it has to be increased on the load balancer and the backend server.")
	private Integer maxAjpPacketSize;
	@AttributeDocumentation("Maximum size of a buffered request, in bytes. Requests are not usually buffered, the most common case is when performing SSL renegotiation for a POST request, and the post data must be fully buffered in order to perform the renegotiation.")
	private Integer maxBufferedRequestSize;
	@AttributeDocumentation("The maximum number of concurrent connections. Only values greater than 0 are allowed. For unlimited connections simply undefine this attribute value.")
	private Integer maxConnections;
	@AttributeDocumentation("The maximum number of cookies that will be parsed. This is used to protect against hash vulnerabilities.")
	private Integer maxCookies;
	@AttributeDocumentation("The maximum size of a http request header, in bytes.")
	private Integer maxHeaderSize;
	@AttributeDocumentation("The maximum number of headers that will be parsed. This is used to protect against hash vulnerabilities.")
	private Integer maxHeaders;
	@AttributeDocumentation("The maximum number of parameters that will be parsed. This is used to protect against hash vulnerabilities. This applies to both query parameters, and to POST data, but is not cumulative (i.e. you can potentially have max parameters * 2 total parameters).")
	private Integer maxParameters;
	@AttributeDocumentation("The maximum size of a post that will be accepted, in bytes.")
	private Long maxPostSize;
	@AttributeDocumentation("The maximum processing time taken by a request on this listener")
	private Long maxProcessingTime;
	@AttributeDocumentation("The length of time in milliseconds that the connection can be idle before it is closed by the container.")
	private Integer noRequestTimeout;
	@AttributeDocumentation("The total processing time of all requests handed by this listener")
	private Long processingTime;
	@AttributeDocumentation("Configure a read timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful read taking place, the socket's next read will throw a {@link ReadTimeoutException}.")
	private Integer readTimeout;
	@AttributeDocumentation("The receive buffer size, in bytes.")
	private Integer receiveBuffer;
	@AttributeDocumentation("If this is true then Undertow will record the request start time, to allow for request time to be logged. This has a small but measurable performance impact")
	private Boolean recordRequestStartTime;
	@AttributeDocumentation("If this listener is supporting non-SSL requests, and a request is received for which a matching <security-constraint> requires SSL transport, undertow will automatically redirect the request to the socket binding port specified here.")
	private String redirectSocket;
	@AttributeDocumentation("The number of requests this listener has served")
	private Long requestCount;
	@AttributeDocumentation("The maximum amount of time (in milliseconds) that can be spent parsing the request")
	private Integer requestParseTimeout;
	@AttributeDocumentation("Enables host dns lookup")
	private Boolean resolvePeerAddress;
	@AttributeDocumentation("If cookies should be validated to ensure they comply with RFC6265.")
	private Boolean rfc6265CookieValidation;
	@AttributeDocumentation("The listener scheme, can be HTTP or HTTPS. By default the scheme will be taken from the incoming AJP request.")
	private String scheme;
	@AttributeDocumentation("If this is true then requests that originate from this listener are marked as secure, even if the request is not using HTTPS.")
	private Boolean secure;
	@AttributeDocumentation("The send buffer size, in bytes.")
	private Integer sendBuffer;
	@AttributeDocumentation("The listener socket binding")
	private String socketBinding;
	@AttributeDocumentation("Configure a server with the specified backlog.")
	private Integer tcpBacklog;
	@AttributeDocumentation("Configure a channel to send TCP keep-alive messages in an implementation-dependent manner.")
	private Boolean tcpKeepAlive;
	@AttributeDocumentation("URL charset")
	private String urlCharset;
	@AttributeDocumentation("The listeners XNIO worker")
	private String worker;
	@AttributeDocumentation("Configure a write timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful write taking place, the socket's next write will throw a {@link WriteTimeoutException}.")
	private Integer writeTimeout;

	public AJPListener(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If a request comes in with encoded / characters (i.e. %2F), will these be
	 * decoded.
	 */
	@ModelNodeBinding(detypedName = "allow-encoded-slash")
	public Boolean allowEncodedSlash() {
		return this.allowEncodedSlash;
	}

	/**
	 * If a request comes in with encoded / characters (i.e. %2F), will these be
	 * decoded.
	 */
	@SuppressWarnings("unchecked")
	public T allowEncodedSlash(java.lang.Boolean value) {
		Object oldValue = this.allowEncodedSlash;
		this.allowEncodedSlash = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowEncodedSlash", oldValue, value);
		return (T) this;
	}

	/**
	 * If this is true then Undertow will allow non-escaped equals characters in
	 * unquoted cookie values. Unquoted cookie values may not contain equals
	 * characters. If present the value ends before the equals sign. The
	 * remainder of the cookie value will be dropped.
	 */
	@ModelNodeBinding(detypedName = "allow-equals-in-cookie-value")
	public Boolean allowEqualsInCookieValue() {
		return this.allowEqualsInCookieValue;
	}

	/**
	 * If this is true then Undertow will allow non-escaped equals characters in
	 * unquoted cookie values. Unquoted cookie values may not contain equals
	 * characters. If present the value ends before the equals sign. The
	 * remainder of the cookie value will be dropped.
	 */
	@SuppressWarnings("unchecked")
	public T allowEqualsInCookieValue(java.lang.Boolean value) {
		Object oldValue = this.allowEqualsInCookieValue;
		this.allowEqualsInCookieValue = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowEqualsInCookieValue", oldValue,
					value);
		return (T) this;
	}

	/**
	 * If this is true Undertow will accept non-encoded characters that are
	 * disallowed by the URI specification. This defaults to false, and in
	 * general should not be needed as most clients correctly encode characters.
	 * Note that setting this to true can be considered a security risk, as
	 * allowing non-standard characters can allow request smuggling attacks in
	 * some circumstances.
	 */
	@ModelNodeBinding(detypedName = "allow-unescaped-characters-in-url")
	public Boolean allowUnescapedCharactersInUrl() {
		return this.allowUnescapedCharactersInUrl;
	}

	/**
	 * If this is true Undertow will accept non-encoded characters that are
	 * disallowed by the URI specification. This defaults to false, and in
	 * general should not be needed as most clients correctly encode characters.
	 * Note that setting this to true can be considered a security risk, as
	 * allowing non-standard characters can allow request smuggling attacks in
	 * some circumstances.
	 */
	@SuppressWarnings("unchecked")
	public T allowUnescapedCharactersInUrl(java.lang.Boolean value) {
		Object oldValue = this.allowUnescapedCharactersInUrl;
		this.allowUnescapedCharactersInUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowUnescapedCharactersInUrl",
					oldValue, value);
		return (T) this;
	}

	/**
	 * If this is true then a Connection: keep-alive header will be added to
	 * responses, even when it is not strictly required by the specification.
	 */
	@ModelNodeBinding(detypedName = "always-set-keep-alive")
	public Boolean alwaysSetKeepAlive() {
		return this.alwaysSetKeepAlive;
	}

	/**
	 * If this is true then a Connection: keep-alive header will be added to
	 * responses, even when it is not strictly required by the specification.
	 */
	@SuppressWarnings("unchecked")
	public T alwaysSetKeepAlive(java.lang.Boolean value) {
		Object oldValue = this.alwaysSetKeepAlive;
		this.alwaysSetKeepAlive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("alwaysSetKeepAlive", oldValue, value);
		return (T) this;
	}

	/**
	 * If we should buffer pipelined requests.
	 */
	@ModelNodeBinding(detypedName = "buffer-pipelined-data")
	public Boolean bufferPipelinedData() {
		return this.bufferPipelinedData;
	}

	/**
	 * If we should buffer pipelined requests.
	 */
	@SuppressWarnings("unchecked")
	public T bufferPipelinedData(java.lang.Boolean value) {
		Object oldValue = this.bufferPipelinedData;
		this.bufferPipelinedData = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bufferPipelinedData", oldValue, value);
		return (T) this;
	}

	/**
	 * The listeners buffer pool
	 */
	@ModelNodeBinding(detypedName = "buffer-pool")
	public String bufferPool() {
		return this.bufferPool;
	}

	/**
	 * The listeners buffer pool
	 */
	@SuppressWarnings("unchecked")
	public T bufferPool(java.lang.String value) {
		Object oldValue = this.bufferPool;
		this.bufferPool = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bufferPool", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of bytes that have been received by this listener
	 */
	@ModelNodeBinding(detypedName = "bytes-received")
	public Long bytesReceived() {
		return this.bytesReceived;
	}

	/**
	 * The number of bytes that have been received by this listener
	 */
	@SuppressWarnings("unchecked")
	public T bytesReceived(java.lang.Long value) {
		Object oldValue = this.bytesReceived;
		this.bytesReceived = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bytesReceived", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of bytes that have been sent out on this listener
	 */
	@ModelNodeBinding(detypedName = "bytes-sent")
	public Long bytesSent() {
		return this.bytesSent;
	}

	/**
	 * The number of bytes that have been sent out on this listener
	 */
	@SuppressWarnings("unchecked")
	public T bytesSent(java.lang.Long value) {
		Object oldValue = this.bytesSent;
		this.bytesSent = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bytesSent", oldValue, value);
		return (T) this;
	}

	/**
	 * If this is true then the parser will decode the URL and query parameters
	 * using the selected character encoding (UTF-8 by default). If this is
	 * false they will not be decoded. This will allow a later handler to decode
	 * them into whatever charset is desired.
	 */
	@ModelNodeBinding(detypedName = "decode-url")
	public Boolean decodeUrl() {
		return this.decodeUrl;
	}

	/**
	 * If this is true then the parser will decode the URL and query parameters
	 * using the selected character encoding (UTF-8 by default). If this is
	 * false they will not be decoded. This will allow a later handler to decode
	 * them into whatever charset is desired.
	 */
	@SuppressWarnings("unchecked")
	public T decodeUrl(java.lang.Boolean value) {
		Object oldValue = this.decodeUrl;
		this.decodeUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("decodeUrl", oldValue, value);
		return (T) this;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	@ModelNodeBinding(detypedName = "disallowed-methods")
	public List<String> disallowedMethods() {
		return this.disallowedMethods;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	@SuppressWarnings("unchecked")
	public T disallowedMethods(java.util.List<String> value) {
		Object oldValue = this.disallowedMethods;
		this.disallowedMethods = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disallowedMethods", oldValue, value);
		return (T) this;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	@SuppressWarnings("unchecked")
	public T disallowedMethod(String value) {
		if (this.disallowedMethods == null) {
			this.disallowedMethods = new java.util.ArrayList<>();
		}
		this.disallowedMethods.add(value);
		return (T) this;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	@SuppressWarnings("unchecked")
	public T disallowedMethods(String... args) {
		disallowedMethods(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The number of 500 responses that have been sent by this listener
	 */
	@ModelNodeBinding(detypedName = "error-count")
	public Long errorCount() {
		return this.errorCount;
	}

	/**
	 * The number of 500 responses that have been sent by this listener
	 */
	@SuppressWarnings("unchecked")
	public T errorCount(java.lang.Long value) {
		Object oldValue = this.errorCount;
		this.errorCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("errorCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum supported size of AJP packets. If this is modified it has to
	 * be increased on the load balancer and the backend server.
	 */
	@ModelNodeBinding(detypedName = "max-ajp-packet-size")
	public Integer maxAjpPacketSize() {
		return this.maxAjpPacketSize;
	}

	/**
	 * The maximum supported size of AJP packets. If this is modified it has to
	 * be increased on the load balancer and the backend server.
	 */
	@SuppressWarnings("unchecked")
	public T maxAjpPacketSize(java.lang.Integer value) {
		Object oldValue = this.maxAjpPacketSize;
		this.maxAjpPacketSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxAjpPacketSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Maximum size of a buffered request, in bytes. Requests are not usually
	 * buffered, the most common case is when performing SSL renegotiation for a
	 * POST request, and the post data must be fully buffered in order to
	 * perform the renegotiation.
	 */
	@ModelNodeBinding(detypedName = "max-buffered-request-size")
	public Integer maxBufferedRequestSize() {
		return this.maxBufferedRequestSize;
	}

	/**
	 * Maximum size of a buffered request, in bytes. Requests are not usually
	 * buffered, the most common case is when performing SSL renegotiation for a
	 * POST request, and the post data must be fully buffered in order to
	 * perform the renegotiation.
	 */
	@SuppressWarnings("unchecked")
	public T maxBufferedRequestSize(java.lang.Integer value) {
		Object oldValue = this.maxBufferedRequestSize;
		this.maxBufferedRequestSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxBufferedRequestSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of concurrent connections. Only values greater than 0
	 * are allowed. For unlimited connections simply undefine this attribute
	 * value.
	 */
	@ModelNodeBinding(detypedName = "max-connections")
	public Integer maxConnections() {
		return this.maxConnections;
	}

	/**
	 * The maximum number of concurrent connections. Only values greater than 0
	 * are allowed. For unlimited connections simply undefine this attribute
	 * value.
	 */
	@SuppressWarnings("unchecked")
	public T maxConnections(java.lang.Integer value) {
		Object oldValue = this.maxConnections;
		this.maxConnections = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxConnections", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of cookies that will be parsed. This is used to
	 * protect against hash vulnerabilities.
	 */
	@ModelNodeBinding(detypedName = "max-cookies")
	public Integer maxCookies() {
		return this.maxCookies;
	}

	/**
	 * The maximum number of cookies that will be parsed. This is used to
	 * protect against hash vulnerabilities.
	 */
	@SuppressWarnings("unchecked")
	public T maxCookies(java.lang.Integer value) {
		Object oldValue = this.maxCookies;
		this.maxCookies = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxCookies", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum size of a http request header, in bytes.
	 */
	@ModelNodeBinding(detypedName = "max-header-size")
	public Integer maxHeaderSize() {
		return this.maxHeaderSize;
	}

	/**
	 * The maximum size of a http request header, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T maxHeaderSize(java.lang.Integer value) {
		Object oldValue = this.maxHeaderSize;
		this.maxHeaderSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxHeaderSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of headers that will be parsed. This is used to
	 * protect against hash vulnerabilities.
	 */
	@ModelNodeBinding(detypedName = "max-headers")
	public Integer maxHeaders() {
		return this.maxHeaders;
	}

	/**
	 * The maximum number of headers that will be parsed. This is used to
	 * protect against hash vulnerabilities.
	 */
	@SuppressWarnings("unchecked")
	public T maxHeaders(java.lang.Integer value) {
		Object oldValue = this.maxHeaders;
		this.maxHeaders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxHeaders", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of parameters that will be parsed. This is used to
	 * protect against hash vulnerabilities. This applies to both query
	 * parameters, and to POST data, but is not cumulative (i.e. you can
	 * potentially have max parameters * 2 total parameters).
	 */
	@ModelNodeBinding(detypedName = "max-parameters")
	public Integer maxParameters() {
		return this.maxParameters;
	}

	/**
	 * The maximum number of parameters that will be parsed. This is used to
	 * protect against hash vulnerabilities. This applies to both query
	 * parameters, and to POST data, but is not cumulative (i.e. you can
	 * potentially have max parameters * 2 total parameters).
	 */
	@SuppressWarnings("unchecked")
	public T maxParameters(java.lang.Integer value) {
		Object oldValue = this.maxParameters;
		this.maxParameters = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxParameters", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum size of a post that will be accepted, in bytes.
	 */
	@ModelNodeBinding(detypedName = "max-post-size")
	public Long maxPostSize() {
		return this.maxPostSize;
	}

	/**
	 * The maximum size of a post that will be accepted, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T maxPostSize(java.lang.Long value) {
		Object oldValue = this.maxPostSize;
		this.maxPostSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxPostSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum processing time taken by a request on this listener
	 */
	@ModelNodeBinding(detypedName = "max-processing-time")
	public Long maxProcessingTime() {
		return this.maxProcessingTime;
	}

	/**
	 * The maximum processing time taken by a request on this listener
	 */
	@SuppressWarnings("unchecked")
	public T maxProcessingTime(java.lang.Long value) {
		Object oldValue = this.maxProcessingTime;
		this.maxProcessingTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxProcessingTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The length of time in milliseconds that the connection can be idle before
	 * it is closed by the container.
	 */
	@ModelNodeBinding(detypedName = "no-request-timeout")
	public Integer noRequestTimeout() {
		return this.noRequestTimeout;
	}

	/**
	 * The length of time in milliseconds that the connection can be idle before
	 * it is closed by the container.
	 */
	@SuppressWarnings("unchecked")
	public T noRequestTimeout(java.lang.Integer value) {
		Object oldValue = this.noRequestTimeout;
		this.noRequestTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("noRequestTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The total processing time of all requests handed by this listener
	 */
	@ModelNodeBinding(detypedName = "processing-time")
	public Long processingTime() {
		return this.processingTime;
	}

	/**
	 * The total processing time of all requests handed by this listener
	 */
	@SuppressWarnings("unchecked")
	public T processingTime(java.lang.Long value) {
		Object oldValue = this.processingTime;
		this.processingTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("processingTime", oldValue, value);
		return (T) this;
	}

	/**
	 * Configure a read timeout for a socket, in milliseconds. If the given
	 * amount of time elapses without a successful read taking place, the
	 * socket's next read will throw a {@link ReadTimeoutException}.
	 */
	@ModelNodeBinding(detypedName = "read-timeout")
	public Integer readTimeout() {
		return this.readTimeout;
	}

	/**
	 * Configure a read timeout for a socket, in milliseconds. If the given
	 * amount of time elapses without a successful read taking place, the
	 * socket's next read will throw a {@link ReadTimeoutException}.
	 */
	@SuppressWarnings("unchecked")
	public T readTimeout(java.lang.Integer value) {
		Object oldValue = this.readTimeout;
		this.readTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("readTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The receive buffer size, in bytes.
	 */
	@ModelNodeBinding(detypedName = "receive-buffer")
	public Integer receiveBuffer() {
		return this.receiveBuffer;
	}

	/**
	 * The receive buffer size, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T receiveBuffer(java.lang.Integer value) {
		Object oldValue = this.receiveBuffer;
		this.receiveBuffer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("receiveBuffer", oldValue, value);
		return (T) this;
	}

	/**
	 * If this is true then Undertow will record the request start time, to
	 * allow for request time to be logged. This has a small but measurable
	 * performance impact
	 */
	@ModelNodeBinding(detypedName = "record-request-start-time")
	public Boolean recordRequestStartTime() {
		return this.recordRequestStartTime;
	}

	/**
	 * If this is true then Undertow will record the request start time, to
	 * allow for request time to be logged. This has a small but measurable
	 * performance impact
	 */
	@SuppressWarnings("unchecked")
	public T recordRequestStartTime(java.lang.Boolean value) {
		Object oldValue = this.recordRequestStartTime;
		this.recordRequestStartTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recordRequestStartTime", oldValue,
					value);
		return (T) this;
	}

	/**
	 * If this listener is supporting non-SSL requests, and a request is
	 * received for which a matching <security-constraint> requires SSL
	 * transport, undertow will automatically redirect the request to the socket
	 * binding port specified here.
	 */
	@ModelNodeBinding(detypedName = "redirect-socket")
	public String redirectSocket() {
		return this.redirectSocket;
	}

	/**
	 * If this listener is supporting non-SSL requests, and a request is
	 * received for which a matching <security-constraint> requires SSL
	 * transport, undertow will automatically redirect the request to the socket
	 * binding port specified here.
	 */
	@SuppressWarnings("unchecked")
	public T redirectSocket(java.lang.String value) {
		Object oldValue = this.redirectSocket;
		this.redirectSocket = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("redirectSocket", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of requests this listener has served
	 */
	@ModelNodeBinding(detypedName = "request-count")
	public Long requestCount() {
		return this.requestCount;
	}

	/**
	 * The number of requests this listener has served
	 */
	@SuppressWarnings("unchecked")
	public T requestCount(java.lang.Long value) {
		Object oldValue = this.requestCount;
		this.requestCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requestCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum amount of time (in milliseconds) that can be spent parsing
	 * the request
	 */
	@ModelNodeBinding(detypedName = "request-parse-timeout")
	public Integer requestParseTimeout() {
		return this.requestParseTimeout;
	}

	/**
	 * The maximum amount of time (in milliseconds) that can be spent parsing
	 * the request
	 */
	@SuppressWarnings("unchecked")
	public T requestParseTimeout(java.lang.Integer value) {
		Object oldValue = this.requestParseTimeout;
		this.requestParseTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requestParseTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Enables host dns lookup
	 */
	@ModelNodeBinding(detypedName = "resolve-peer-address")
	public Boolean resolvePeerAddress() {
		return this.resolvePeerAddress;
	}

	/**
	 * Enables host dns lookup
	 */
	@SuppressWarnings("unchecked")
	public T resolvePeerAddress(java.lang.Boolean value) {
		Object oldValue = this.resolvePeerAddress;
		this.resolvePeerAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("resolvePeerAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * If cookies should be validated to ensure they comply with RFC6265.
	 */
	@ModelNodeBinding(detypedName = "rfc6265-cookie-validation")
	public Boolean rfc6265CookieValidation() {
		return this.rfc6265CookieValidation;
	}

	/**
	 * If cookies should be validated to ensure they comply with RFC6265.
	 */
	@SuppressWarnings("unchecked")
	public T rfc6265CookieValidation(java.lang.Boolean value) {
		Object oldValue = this.rfc6265CookieValidation;
		this.rfc6265CookieValidation = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("rfc6265CookieValidation", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The listener scheme, can be HTTP or HTTPS. By default the scheme will be
	 * taken from the incoming AJP request.
	 */
	@ModelNodeBinding(detypedName = "scheme")
	public String scheme() {
		return this.scheme;
	}

	/**
	 * The listener scheme, can be HTTP or HTTPS. By default the scheme will be
	 * taken from the incoming AJP request.
	 */
	@SuppressWarnings("unchecked")
	public T scheme(java.lang.String value) {
		Object oldValue = this.scheme;
		this.scheme = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("scheme", oldValue, value);
		return (T) this;
	}

	/**
	 * If this is true then requests that originate from this listener are
	 * marked as secure, even if the request is not using HTTPS.
	 */
	@ModelNodeBinding(detypedName = "secure")
	public Boolean secure() {
		return this.secure;
	}

	/**
	 * If this is true then requests that originate from this listener are
	 * marked as secure, even if the request is not using HTTPS.
	 */
	@SuppressWarnings("unchecked")
	public T secure(java.lang.Boolean value) {
		Object oldValue = this.secure;
		this.secure = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("secure", oldValue, value);
		return (T) this;
	}

	/**
	 * The send buffer size, in bytes.
	 */
	@ModelNodeBinding(detypedName = "send-buffer")
	public Integer sendBuffer() {
		return this.sendBuffer;
	}

	/**
	 * The send buffer size, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T sendBuffer(java.lang.Integer value) {
		Object oldValue = this.sendBuffer;
		this.sendBuffer = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sendBuffer", oldValue, value);
		return (T) this;
	}

	/**
	 * The listener socket binding
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The listener socket binding
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Configure a server with the specified backlog.
	 */
	@ModelNodeBinding(detypedName = "tcp-backlog")
	public Integer tcpBacklog() {
		return this.tcpBacklog;
	}

	/**
	 * Configure a server with the specified backlog.
	 */
	@SuppressWarnings("unchecked")
	public T tcpBacklog(java.lang.Integer value) {
		Object oldValue = this.tcpBacklog;
		this.tcpBacklog = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tcpBacklog", oldValue, value);
		return (T) this;
	}

	/**
	 * Configure a channel to send TCP keep-alive messages in an
	 * implementation-dependent manner.
	 */
	@ModelNodeBinding(detypedName = "tcp-keep-alive")
	public Boolean tcpKeepAlive() {
		return this.tcpKeepAlive;
	}

	/**
	 * Configure a channel to send TCP keep-alive messages in an
	 * implementation-dependent manner.
	 */
	@SuppressWarnings("unchecked")
	public T tcpKeepAlive(java.lang.Boolean value) {
		Object oldValue = this.tcpKeepAlive;
		this.tcpKeepAlive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tcpKeepAlive", oldValue, value);
		return (T) this;
	}

	/**
	 * URL charset
	 */
	@ModelNodeBinding(detypedName = "url-charset")
	public String urlCharset() {
		return this.urlCharset;
	}

	/**
	 * URL charset
	 */
	@SuppressWarnings("unchecked")
	public T urlCharset(java.lang.String value) {
		Object oldValue = this.urlCharset;
		this.urlCharset = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("urlCharset", oldValue, value);
		return (T) this;
	}

	/**
	 * The listeners XNIO worker
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * The listeners XNIO worker
	 */
	@SuppressWarnings("unchecked")
	public T worker(java.lang.String value) {
		Object oldValue = this.worker;
		this.worker = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("worker", oldValue, value);
		return (T) this;
	}

	/**
	 * Configure a write timeout for a socket, in milliseconds. If the given
	 * amount of time elapses without a successful write taking place, the
	 * socket's next write will throw a {@link WriteTimeoutException}.
	 */
	@ModelNodeBinding(detypedName = "write-timeout")
	public Integer writeTimeout() {
		return this.writeTimeout;
	}

	/**
	 * Configure a write timeout for a socket, in milliseconds. If the given
	 * amount of time elapses without a successful write taking place, the
	 * socket's next write will throw a {@link WriteTimeoutException}.
	 */
	@SuppressWarnings("unchecked")
	public T writeTimeout(java.lang.Integer value) {
		Object oldValue = this.writeTimeout;
		this.writeTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("writeTimeout", oldValue, value);
		return (T) this;
	}
}