package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The HTTP invoker services that allows remote HTTP based invocation of
 * services such as EJB and naming
 */
@Address("/subsystem=undertow/server=*/host=*/setting=http-invoker")
@ResourceType("setting")
@Implicit
public class HTTPInvokerSetting<T extends HTTPInvokerSetting<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The HTTP authentication factory to use for authentication")
	private String httpAuthenticationFactory;
	@AttributeDocumentation("The path that the services are installed under")
	private String path;
	@AttributeDocumentation("The legacy security realm to use for authentication")
	private String securityRealm;

	public HTTPInvokerSetting() {
		super();
		this.key = "http-invoker";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The HTTP authentication factory to use for authentication
	 */
	@ModelNodeBinding(detypedName = "http-authentication-factory")
	public String httpAuthenticationFactory() {
		return this.httpAuthenticationFactory;
	}

	/**
	 * The HTTP authentication factory to use for authentication
	 */
	@SuppressWarnings("unchecked")
	public T httpAuthenticationFactory(java.lang.String value) {
		Object oldValue = this.httpAuthenticationFactory;
		this.httpAuthenticationFactory = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpAuthenticationFactory", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The path that the services are installed under
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The path that the services are installed under
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The legacy security realm to use for authentication
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The legacy security realm to use for authentication
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(java.lang.String value) {
		Object oldValue = this.securityRealm;
		this.securityRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityRealm", oldValue, value);
		return (T) this;
	}
}