package org.wildfly.swarm.config.webservices;

import org.wildfly.swarm.config.webservices.PreHandlerChain;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PreHandlerChainConsumer<T extends PreHandlerChain<T>> {

	/**
	 * Configure a pre-constructed instance of PreHandlerChain resource
	 * 
	 * @parameter Instance of PreHandlerChain to configure
	 * @return nothing
	 */
	void accept(T value);

	default PreHandlerChainConsumer<T> andThen(PreHandlerChainConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}