/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.ee.ContextService;
import org.wildfly.swarm.config.ee.ContextServiceConsumer;
import org.wildfly.swarm.config.ee.ContextServiceSupplier;
import org.wildfly.swarm.config.ee.DefaultBindingsService;
import org.wildfly.swarm.config.ee.DefaultBindingsServiceConsumer;
import org.wildfly.swarm.config.ee.DefaultBindingsServiceSupplier;
import org.wildfly.swarm.config.ee.ManagedExecutorService;
import org.wildfly.swarm.config.ee.ManagedExecutorServiceConsumer;
import org.wildfly.swarm.config.ee.ManagedExecutorServiceSupplier;
import org.wildfly.swarm.config.ee.ManagedScheduledExecutorService;
import org.wildfly.swarm.config.ee.ManagedScheduledExecutorServiceConsumer;
import org.wildfly.swarm.config.ee.ManagedScheduledExecutorServiceSupplier;
import org.wildfly.swarm.config.ee.ManagedThreadFactory;
import org.wildfly.swarm.config.ee.ManagedThreadFactoryConsumer;
import org.wildfly.swarm.config.ee.ManagedThreadFactorySupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=ee")
@ResourceType(value="subsystem")
@Implicit
public class EE<T extends EE<T>>
implements Keyed {
    private String key = "ee";
    private PropertyChangeSupport pcs;
    private EEResources subresources = new EEResources();
    @AttributeDocumentation(value="Flag indicating whether Java EE annotations will have property replacements applied")
    private Boolean annotationPropertyReplacement;
    @AttributeDocumentation(value="Flag indicating whether each of the subdeployments within a .ear can access classes belonging to another subdeployment within the same .ear. A value of false means the subdeployments can see classes belonging to other subdeployments within the .ear.")
    private Boolean earSubdeploymentsIsolated;
    @AttributeDocumentation(value="A list of modules that should be made available to all deployments.")
    private List<Map> globalModules;
    @AttributeDocumentation(value="Flag indicating whether JBoss specific deployment descriptors will have property replacements applied")
    private Boolean jbossDescriptorPropertyReplacement;
    @AttributeDocumentation(value="Flag indicating whether descriptors defined by the Java EE specification will have property replacements applied")
    private Boolean specDescriptorPropertyReplacement;

    public EE() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public EEResources subresources() {
        return this.subresources;
    }

    public T managedThreadFactories(List<ManagedThreadFactory> value) {
        this.subresources.managedThreadFactories = value;
        return (T)this;
    }

    public T managedThreadFactory(ManagedThreadFactory value) {
        this.subresources.managedThreadFactories.add(value);
        return (T)this;
    }

    public T managedThreadFactory(String childKey, ManagedThreadFactoryConsumer consumer) {
        ManagedThreadFactory child = new ManagedThreadFactory(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.managedThreadFactory(child);
        return (T)this;
    }

    public T managedThreadFactory(String childKey) {
        this.managedThreadFactory(childKey, null);
        return (T)this;
    }

    public T managedThreadFactory(ManagedThreadFactorySupplier supplier) {
        this.managedThreadFactory(supplier.get());
        return (T)this;
    }

    public T contextServices(List<ContextService> value) {
        this.subresources.contextServices = value;
        return (T)this;
    }

    public T contextService(ContextService value) {
        this.subresources.contextServices.add(value);
        return (T)this;
    }

    public T contextService(String childKey, ContextServiceConsumer consumer) {
        ContextService child = new ContextService(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.contextService(child);
        return (T)this;
    }

    public T contextService(String childKey) {
        this.contextService(childKey, null);
        return (T)this;
    }

    public T contextService(ContextServiceSupplier supplier) {
        this.contextService(supplier.get());
        return (T)this;
    }

    public T managedExecutorServices(List<ManagedExecutorService> value) {
        this.subresources.managedExecutorServices = value;
        return (T)this;
    }

    public T managedExecutorService(ManagedExecutorService value) {
        this.subresources.managedExecutorServices.add(value);
        return (T)this;
    }

    public T managedExecutorService(String childKey, ManagedExecutorServiceConsumer consumer) {
        ManagedExecutorService child = new ManagedExecutorService(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.managedExecutorService(child);
        return (T)this;
    }

    public T managedExecutorService(String childKey) {
        this.managedExecutorService(childKey, null);
        return (T)this;
    }

    public T managedExecutorService(ManagedExecutorServiceSupplier supplier) {
        this.managedExecutorService(supplier.get());
        return (T)this;
    }

    public T managedScheduledExecutorServices(List<ManagedScheduledExecutorService> value) {
        this.subresources.managedScheduledExecutorServices = value;
        return (T)this;
    }

    public T managedScheduledExecutorService(ManagedScheduledExecutorService value) {
        this.subresources.managedScheduledExecutorServices.add(value);
        return (T)this;
    }

    public T managedScheduledExecutorService(String childKey, ManagedScheduledExecutorServiceConsumer consumer) {
        ManagedScheduledExecutorService child = new ManagedScheduledExecutorService(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.managedScheduledExecutorService(child);
        return (T)this;
    }

    public T managedScheduledExecutorService(String childKey) {
        this.managedScheduledExecutorService(childKey, null);
        return (T)this;
    }

    public T managedScheduledExecutorService(ManagedScheduledExecutorServiceSupplier supplier) {
        this.managedScheduledExecutorService(supplier.get());
        return (T)this;
    }

    public T defaultBindingsService(DefaultBindingsService value) {
        this.subresources.defaultBindingsService = value;
        return (T)this;
    }

    public T defaultBindingsService(DefaultBindingsServiceConsumer consumer) {
        DefaultBindingsService child = new DefaultBindingsService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.defaultBindingsService = child;
        return (T)this;
    }

    public T defaultBindingsService() {
        DefaultBindingsService child = new DefaultBindingsService();
        this.subresources.defaultBindingsService = child;
        return (T)this;
    }

    public T defaultBindingsService(DefaultBindingsServiceSupplier supplier) {
        this.subresources.defaultBindingsService = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="annotation-property-replacement")
    public Boolean annotationPropertyReplacement() {
        return this.annotationPropertyReplacement;
    }

    public T annotationPropertyReplacement(Boolean value) {
        Boolean oldValue = this.annotationPropertyReplacement;
        this.annotationPropertyReplacement = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("annotationPropertyReplacement", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ear-subdeployments-isolated")
    public Boolean earSubdeploymentsIsolated() {
        return this.earSubdeploymentsIsolated;
    }

    public T earSubdeploymentsIsolated(Boolean value) {
        Boolean oldValue = this.earSubdeploymentsIsolated;
        this.earSubdeploymentsIsolated = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("earSubdeploymentsIsolated", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-modules")
    public List<Map> globalModules() {
        return this.globalModules;
    }

    public T globalModules(List<Map> value) {
        List<Map> oldValue = this.globalModules;
        this.globalModules = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalModules", oldValue, value);
        }
        return (T)this;
    }

    public T globalModule(Map value) {
        if (this.globalModules == null) {
            this.globalModules = new ArrayList<Map>();
        }
        this.globalModules.add(value);
        return (T)this;
    }

    public T globalModules(Map ... args) {
        this.globalModules(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jboss-descriptor-property-replacement")
    public Boolean jbossDescriptorPropertyReplacement() {
        return this.jbossDescriptorPropertyReplacement;
    }

    public T jbossDescriptorPropertyReplacement(Boolean value) {
        Boolean oldValue = this.jbossDescriptorPropertyReplacement;
        this.jbossDescriptorPropertyReplacement = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jbossDescriptorPropertyReplacement", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="spec-descriptor-property-replacement")
    public Boolean specDescriptorPropertyReplacement() {
        return this.specDescriptorPropertyReplacement;
    }

    public T specDescriptorPropertyReplacement(Boolean value) {
        Boolean oldValue = this.specDescriptorPropertyReplacement;
        this.specDescriptorPropertyReplacement = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("specDescriptorPropertyReplacement", oldValue, value);
        }
        return (T)this;
    }

    public static class EEResources {
        @ResourceDocumentation(value="A managed thread factory")
        @SubresourceInfo(value="managedThreadFactory")
        private List<ManagedThreadFactory> managedThreadFactories = new ArrayList<ManagedThreadFactory>();
        @ResourceDocumentation(value="A context service")
        @SubresourceInfo(value="contextService")
        private List<ContextService> contextServices = new ArrayList<ContextService>();
        @ResourceDocumentation(value="A managed executor service")
        @SubresourceInfo(value="managedExecutorService")
        private List<ManagedExecutorService> managedExecutorServices = new ArrayList<ManagedExecutorService>();
        @ResourceDocumentation(value="A managed scheduled executor service")
        @SubresourceInfo(value="managedScheduledExecutorService")
        private List<ManagedScheduledExecutorService> managedScheduledExecutorServices = new ArrayList<ManagedScheduledExecutorService>();
        @SingletonResource
        @ResourceDocumentation(value="The JNDI names for the default EE bindings")
        private DefaultBindingsService defaultBindingsService;

        @Subresource
        public List<ManagedThreadFactory> managedThreadFactories() {
            return this.managedThreadFactories;
        }

        public ManagedThreadFactory managedThreadFactory(String key) {
            return this.managedThreadFactories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ContextService> contextServices() {
            return this.contextServices;
        }

        public ContextService contextService(String key) {
            return this.contextServices.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ManagedExecutorService> managedExecutorServices() {
            return this.managedExecutorServices;
        }

        public ManagedExecutorService managedExecutorService(String key) {
            return this.managedExecutorServices.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ManagedScheduledExecutorService> managedScheduledExecutorServices() {
            return this.managedScheduledExecutorServices;
        }

        public ManagedScheduledExecutorService managedScheduledExecutorService(String key) {
            return this.managedScheduledExecutorServices.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public DefaultBindingsService defaultBindingsService() {
            return this.defaultBindingsService;
        }
    }
}

