/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapter;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapterConsumer;
import org.wildfly.swarm.config.resource.adapters.ResourceAdapterSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=resource-adapters")
@ResourceType(value="subsystem")
@Implicit
public class ResourceAdapters<T extends ResourceAdapters<T>>
implements Keyed {
    private String key = "resource-adapters";
    private PropertyChangeSupport pcs;
    private ResourceAdaptersResources subresources = new ResourceAdaptersResources();

    public ResourceAdapters() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ResourceAdaptersResources subresources() {
        return this.subresources;
    }

    public T resourceAdapters(List<ResourceAdapter> value) {
        this.subresources.resourceAdapters = value;
        return (T)this;
    }

    public T resourceAdapter(ResourceAdapter value) {
        this.subresources.resourceAdapters.add(value);
        return (T)this;
    }

    public T resourceAdapter(String childKey, ResourceAdapterConsumer consumer) {
        ResourceAdapter child = new ResourceAdapter(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.resourceAdapter(child);
        return (T)this;
    }

    public T resourceAdapter(String childKey) {
        this.resourceAdapter(childKey, null);
        return (T)this;
    }

    public T resourceAdapter(ResourceAdapterSupplier supplier) {
        this.resourceAdapter(supplier.get());
        return (T)this;
    }

    public static class ResourceAdaptersResources {
        @ResourceDocumentation(value="The configuration of a resource adapter.")
        @SubresourceInfo(value="resourceAdapter")
        private List<ResourceAdapter> resourceAdapters = new ArrayList<ResourceAdapter>();

        @Subresource
        public List<ResourceAdapter> resourceAdapters() {
            return this.resourceAdapters;
        }

        public ResourceAdapter resourceAdapter(String key) {
            return this.resourceAdapters.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

