/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.datasources;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.datasources.FlushStrategy;
import org.wildfly.swarm.config.datasources.data_source.ConnectionProperties;
import org.wildfly.swarm.config.datasources.data_source.ConnectionPropertiesConsumer;
import org.wildfly.swarm.config.datasources.data_source.ConnectionPropertiesSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=datasources/data-source=*")
@ResourceType(value="data-source")
public class DataSource<T extends DataSource<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private DataSourceResources subresources = new DataSourceResources();
    @AttributeDocumentation(value="The allocation retry element indicates the number of times that allocating a connection should be tried before throwing an exception")
    private Integer allocationRetry;
    @AttributeDocumentation(value="The allocation retry wait millis element specifies the amount of time, in milliseconds, to wait between retrying to allocate a connection")
    private Long allocationRetryWaitMillis;
    @AttributeDocumentation(value="Specifies if multiple users will access the datasource through the getConnection(user, password) method and hence if the internal pool type should account for that")
    private Boolean allowMultipleUsers;
    @AttributeDocumentation(value="The Elytron authentication context which defines the javax.security.auth.Subject that is used to distinguish connections in the pool.")
    private String authenticationContext;
    @AttributeDocumentation(value="An element to specify that connections should be validated on a background thread versus being validated prior to use. Changing this value can be done only on disabled datasource,  requires a server restart otherwise.")
    private Boolean backgroundValidation;
    @AttributeDocumentation(value="The background-validation-millis element specifies the amount of time, in milliseconds, that background validation will run. Changing this value can be done only on disabled datasource,  requires a server restart otherwise")
    private Long backgroundValidationMillis;
    @AttributeDocumentation(value="The blocking-timeout-millis element specifies the maximum time, in milliseconds, to block while waiting for a connection before throwing an exception. Note that this blocks only while waiting for locking a connection, and will never throw an exception if creating a new connection takes an inordinately long time")
    private Long blockingTimeoutWaitMillis;
    @AttributeDocumentation(value="Class defining the policy for decrementing connections in the pool")
    private String capacityDecrementerClass;
    @AttributeDocumentation(value="Properties to be injected in class defining the policy for decrementing connections in the pool")
    private Map capacityDecrementerProperties;
    @AttributeDocumentation(value="Class defining the policy for incrementing connections in the pool")
    private String capacityIncrementerClass;
    @AttributeDocumentation(value="Properties to be injected in class defining the policy for incrementing connections in the pool")
    private Map capacityIncrementerProperties;
    @AttributeDocumentation(value="Specify an SQL statement to check validity of a pool connection. This may be called when managed connection is obtained from the pool")
    private String checkValidConnectionSql;
    @AttributeDocumentation(value="Enable the use of CMR. This feature means that a local resource can reliably participate in an XA transaction.")
    private Boolean connectable;
    @AttributeDocumentation(value="Speciefies class name extending org.jboss.jca.adapters.jdbc.spi.listener.ConnectionListener that provides a possible to listen for connection activation and passivation in order to perform actions before the connection is returned to the application or returned to the pool.")
    private String connectionListenerClass;
    @AttributeDocumentation(value="Properties to be injected in class specidied in connection-listener-class")
    private Map connectionListenerProperty;
    @AttributeDocumentation(value="The JDBC driver connection URL")
    private String connectionUrl;
    @AttributeDocumentation(value="Credential (from Credential Store) to authenticate on data source")
    private Map credentialReference;
    @AttributeDocumentation(value="The fully qualified name of the JDBC datasource class")
    private String datasourceClass;
    @AttributeDocumentation(value="The fully qualified name of the JDBC driver class")
    private String driverClass;
    @AttributeDocumentation(value="Defines the JDBC driver the datasource should use. It is a symbolic name matching the the name of installed driver. In case the driver is deployed as jar, the name is the name of deployment unit")
    private String driverName;
    @AttributeDocumentation(value="Enables Elytron security for handling authentication of connections. The Elytron authentication-context to be used will be current context if no context is specified (see authentication-context).")
    private Boolean elytronEnabled;
    @AttributeDocumentation(value="Defines if WildFly/IronJacamar should record enlistment traces")
    private Boolean enlistmentTrace;
    @AttributeDocumentation(value="An org.jboss.jca.adapters.jdbc.ExceptionSorter that provides an isExceptionFatal(SQLException) method to validate if an exception should broadcast an error")
    private String exceptionSorterClassName;
    @AttributeDocumentation(value="The exception sorter properties")
    private Map exceptionSorterProperties;
    @AttributeDocumentation(value="Specifies how the pool should be flush in case of an error.")
    private FlushStrategy flushStrategy;
    @AttributeDocumentation(value="The idle-timeout-minutes elements specifies the maximum time, in minutes, a connection may be idle before being closed. The actual maximum time depends also on the IdleRemover scan time, which is half of the smallest idle-timeout-minutes value of any pool. Changing this value can be done only on disabled datasource, requires a server restart otherwise.")
    private Long idleTimeoutMinutes;
    @AttributeDocumentation(value="The initial-pool-size element indicates the initial number of connections a pool should hold.")
    private Integer initialPoolSize;
    @AttributeDocumentation(value="Specifies the JNDI name for the datasource")
    private String jndiName;
    @AttributeDocumentation(value="Enable JTA integration")
    private Boolean jta;
    @AttributeDocumentation(value="The max-pool-size element specifies the maximum number of connections for a pool. No more connections will be created in each sub-pool")
    private Integer maxPoolSize;
    @AttributeDocumentation(value="Defines the ManagedConnectionPool implementation, f.ex. org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool")
    private String mcp;
    @AttributeDocumentation(value="The min-pool-size element specifies the minimum number of connections for a pool")
    private Integer minPoolSize;
    @AttributeDocumentation(value="Specifies an SQL statement to execute whenever a connection is added to the connection pool")
    private String newConnectionSql;
    @AttributeDocumentation(value="Specifies the password used when creating a new connection")
    private String password;
    @AttributeDocumentation(value="Defines if pool use should be fair")
    private Boolean poolFair;
    @AttributeDocumentation(value="Should the pool be prefilled. Changing this value can be done only on disabled datasource, requires a server restart otherwise.")
    private Boolean poolPrefill;
    @AttributeDocumentation(value="Specifies if the min-pool-size should be considered strictly")
    private Boolean poolUseStrictMin;
    @AttributeDocumentation(value="The number of prepared statements per connection in an LRU cache")
    private Long preparedStatementsCacheSize;
    @AttributeDocumentation(value="Any configured query timeout in seconds. If not provided no timeout will be set")
    private Long queryTimeout;
    @AttributeDocumentation(value="The fully qualified class name of the reauthentication plugin implementation")
    private String reauthPluginClassName;
    @AttributeDocumentation(value="The properties for the reauthentication plugin")
    private Map reauthPluginProperties;
    @AttributeDocumentation(value="Specifies the PicketBox security domain which defines the PicketBox javax.security.auth.Subject that are used to distinguish connections in the pool")
    private String securityDomain;
    @AttributeDocumentation(value="Whether to set the query timeout based on the time remaining until transaction timeout. Any configured query timeout will be used if there is no transaction")
    private Boolean setTxQueryTimeout;
    @AttributeDocumentation(value="Whether to share prepared statements, i.e. whether asking for same statement twice without closing uses the same underlying prepared statement")
    private Boolean sharePreparedStatements;
    @AttributeDocumentation(value="Enable spying of SQL statements")
    private Boolean spy;
    @AttributeDocumentation(value="An org.jboss.jca.adapters.jdbc.StaleConnectionChecker that provides an isStaleConnection(SQLException) method which if it returns true will wrap the exception in an org.jboss.jca.adapters.jdbc.StaleConnectionException")
    private String staleConnectionCheckerClassName;
    @AttributeDocumentation(value="The stale connection checker properties")
    private Map staleConnectionCheckerProperties;
    @AttributeDocumentation(value="Define whether runtime statistics are enabled or not.")
    private Boolean statisticsEnabled;
    @AttributeDocumentation(value="Whether to check for unclosed statements when a connection is returned to the pool, result sets are closed, a statement is closed or return to the prepared statement cache. Valid values are: \"false\" - do not track statements, \"true\" - track statements and result sets and warn when they are not closed, \"nowarn\" - track statements but do not warn about them being unclosed")
    private String trackStatements;
    @AttributeDocumentation(value="Defines if IronJacamar should track connection handles across transaction boundaries")
    private Boolean tracking;
    @AttributeDocumentation(value="Set the java.sql.Connection transaction isolation level. Valid values are: TRANSACTION_READ_UNCOMMITTED, TRANSACTION_READ_COMMITTED, TRANSACTION_REPEATABLE_READ, TRANSACTION_SERIALIZABLE and TRANSACTION_NONE. Different values are used to set customLevel using TransactionIsolation#customLevel")
    private String transactionIsolation;
    @AttributeDocumentation(value="Specifies the delimiter for URLs in connection-url for HA datasources")
    private String urlDelimiter;
    @AttributeDocumentation(value="A class that implements org.jboss.jca.adapters.jdbc.URLSelectorStrategy")
    private String urlSelectorStrategyClassName;
    @AttributeDocumentation(value="Enable the use of a cached connection manager")
    private Boolean useCcm;
    @AttributeDocumentation(value="Whether to fail a connection allocation on the first try if it is invalid (true) or keep trying until the pool is exhausted of all potential connections (false)")
    private Boolean useFastFail;
    @AttributeDocumentation(value="Setting this to false will bind the datasource into global JNDI")
    private Boolean useJavaContext;
    @AttributeDocumentation(value="Any configured timeout for internal locks on the resource adapter objects in seconds")
    private Long useTryLock;
    @AttributeDocumentation(value="Specify the user name used when creating a new connection")
    private String userName;
    @AttributeDocumentation(value="An org.jboss.jca.adapters.jdbc.ValidConnectionChecker that provides an isValidConnection(Connection) method to validate a connection. If an exception is returned that means the connection is invalid. This overrides the check-valid-connection-sql element")
    private String validConnectionCheckerClassName;
    @AttributeDocumentation(value="The valid connection checker properties")
    private Map validConnectionCheckerProperties;
    @AttributeDocumentation(value="The validate-on-match element specifies if connection validation should be done when a connection factory attempts to match a managed connection. This is typically exclusive to the use of background validation")
    private Boolean validateOnMatch;

    public DataSource(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public DataSourceResources subresources() {
        return this.subresources;
    }

    public T connectionProperties(List<ConnectionProperties> value) {
        this.subresources.connectionProperties = value;
        return (T)this;
    }

    public T connectionProperties(ConnectionProperties value) {
        this.subresources.connectionProperties.add(value);
        return (T)this;
    }

    public T connectionProperties(String childKey, ConnectionPropertiesConsumer consumer) {
        ConnectionProperties child = new ConnectionProperties(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connectionProperties(child);
        return (T)this;
    }

    public T connectionProperties(String childKey) {
        this.connectionProperties(childKey, null);
        return (T)this;
    }

    public T connectionProperties(ConnectionPropertiesSupplier supplier) {
        this.connectionProperties(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allocation-retry")
    public Integer allocationRetry() {
        return this.allocationRetry;
    }

    public T allocationRetry(Integer value) {
        Integer oldValue = this.allocationRetry;
        this.allocationRetry = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allocationRetry", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allocation-retry-wait-millis")
    public Long allocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public T allocationRetryWaitMillis(Long value) {
        Long oldValue = this.allocationRetryWaitMillis;
        this.allocationRetryWaitMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allocationRetryWaitMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-multiple-users")
    public Boolean allowMultipleUsers() {
        return this.allowMultipleUsers;
    }

    public T allowMultipleUsers(Boolean value) {
        Boolean oldValue = this.allowMultipleUsers;
        this.allowMultipleUsers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowMultipleUsers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-context")
    public String authenticationContext() {
        return this.authenticationContext;
    }

    public T authenticationContext(String value) {
        String oldValue = this.authenticationContext;
        this.authenticationContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="background-validation")
    public Boolean backgroundValidation() {
        return this.backgroundValidation;
    }

    public T backgroundValidation(Boolean value) {
        Boolean oldValue = this.backgroundValidation;
        this.backgroundValidation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backgroundValidation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="background-validation-millis")
    public Long backgroundValidationMillis() {
        return this.backgroundValidationMillis;
    }

    public T backgroundValidationMillis(Long value) {
        Long oldValue = this.backgroundValidationMillis;
        this.backgroundValidationMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backgroundValidationMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="blocking-timeout-wait-millis")
    public Long blockingTimeoutWaitMillis() {
        return this.blockingTimeoutWaitMillis;
    }

    public T blockingTimeoutWaitMillis(Long value) {
        Long oldValue = this.blockingTimeoutWaitMillis;
        this.blockingTimeoutWaitMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("blockingTimeoutWaitMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-decrementer-class")
    public String capacityDecrementerClass() {
        return this.capacityDecrementerClass;
    }

    public T capacityDecrementerClass(String value) {
        String oldValue = this.capacityDecrementerClass;
        this.capacityDecrementerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityDecrementerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-decrementer-properties")
    public Map capacityDecrementerProperties() {
        return this.capacityDecrementerProperties;
    }

    public T capacityDecrementerProperties(Map value) {
        Map oldValue = this.capacityDecrementerProperties;
        this.capacityDecrementerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityDecrementerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T capacityDecrementerProperty(String key, Object value) {
        if (this.capacityDecrementerProperties == null) {
            this.capacityDecrementerProperties = new HashMap();
        }
        this.capacityDecrementerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-incrementer-class")
    public String capacityIncrementerClass() {
        return this.capacityIncrementerClass;
    }

    public T capacityIncrementerClass(String value) {
        String oldValue = this.capacityIncrementerClass;
        this.capacityIncrementerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityIncrementerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-incrementer-properties")
    public Map capacityIncrementerProperties() {
        return this.capacityIncrementerProperties;
    }

    public T capacityIncrementerProperties(Map value) {
        Map oldValue = this.capacityIncrementerProperties;
        this.capacityIncrementerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityIncrementerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T capacityIncrementerProperty(String key, Object value) {
        if (this.capacityIncrementerProperties == null) {
            this.capacityIncrementerProperties = new HashMap();
        }
        this.capacityIncrementerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="check-valid-connection-sql")
    public String checkValidConnectionSql() {
        return this.checkValidConnectionSql;
    }

    public T checkValidConnectionSql(String value) {
        String oldValue = this.checkValidConnectionSql;
        this.checkValidConnectionSql = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("checkValidConnectionSql", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connectable")
    public Boolean connectable() {
        return this.connectable;
    }

    public T connectable(Boolean value) {
        Boolean oldValue = this.connectable;
        this.connectable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-listener-class")
    public String connectionListenerClass() {
        return this.connectionListenerClass;
    }

    public T connectionListenerClass(String value) {
        String oldValue = this.connectionListenerClass;
        this.connectionListenerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionListenerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-listener-property")
    public Map connectionListenerProperty() {
        return this.connectionListenerProperty;
    }

    public T connectionListenerProperty(Map value) {
        Map oldValue = this.connectionListenerProperty;
        this.connectionListenerProperty = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionListenerProperty", oldValue, value);
        }
        return (T)this;
    }

    public T connectionListenerProperty(String key, Object value) {
        if (this.connectionListenerProperty == null) {
            this.connectionListenerProperty = new HashMap();
        }
        this.connectionListenerProperty.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-url")
    public String connectionUrl() {
        return this.connectionUrl;
    }

    public T connectionUrl(String value) {
        String oldValue = this.connectionUrl;
        this.connectionUrl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionUrl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="credential-reference")
    public Map credentialReference() {
        return this.credentialReference;
    }

    public T credentialReference(Map value) {
        Map oldValue = this.credentialReference;
        this.credentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("credentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T credentialReference(String key, Object value) {
        if (this.credentialReference == null) {
            this.credentialReference = new HashMap();
        }
        this.credentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="datasource-class")
    public String datasourceClass() {
        return this.datasourceClass;
    }

    public T datasourceClass(String value) {
        String oldValue = this.datasourceClass;
        this.datasourceClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("datasourceClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-class")
    public String driverClass() {
        return this.driverClass;
    }

    public T driverClass(String value) {
        String oldValue = this.driverClass;
        this.driverClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-name")
    public String driverName() {
        return this.driverName;
    }

    public T driverName(String value) {
        String oldValue = this.driverName;
        this.driverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="elytron-enabled")
    public Boolean elytronEnabled() {
        return this.elytronEnabled;
    }

    public T elytronEnabled(Boolean value) {
        Boolean oldValue = this.elytronEnabled;
        this.elytronEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("elytronEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enlistment-trace")
    public Boolean enlistmentTrace() {
        return this.enlistmentTrace;
    }

    public T enlistmentTrace(Boolean value) {
        Boolean oldValue = this.enlistmentTrace;
        this.enlistmentTrace = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enlistmentTrace", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exception-sorter-class-name")
    public String exceptionSorterClassName() {
        return this.exceptionSorterClassName;
    }

    public T exceptionSorterClassName(String value) {
        String oldValue = this.exceptionSorterClassName;
        this.exceptionSorterClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exceptionSorterClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exception-sorter-properties")
    public Map exceptionSorterProperties() {
        return this.exceptionSorterProperties;
    }

    public T exceptionSorterProperties(Map value) {
        Map oldValue = this.exceptionSorterProperties;
        this.exceptionSorterProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exceptionSorterProperties", oldValue, value);
        }
        return (T)this;
    }

    public T exceptionSorterProperty(String key, Object value) {
        if (this.exceptionSorterProperties == null) {
            this.exceptionSorterProperties = new HashMap();
        }
        this.exceptionSorterProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="flush-strategy")
    public FlushStrategy flushStrategy() {
        return this.flushStrategy;
    }

    public T flushStrategy(FlushStrategy value) {
        FlushStrategy oldValue = this.flushStrategy;
        this.flushStrategy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("flushStrategy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="idle-timeout-minutes")
    public Long idleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public T idleTimeoutMinutes(Long value) {
        Long oldValue = this.idleTimeoutMinutes;
        this.idleTimeoutMinutes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("idleTimeoutMinutes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initial-pool-size")
    public Integer initialPoolSize() {
        return this.initialPoolSize;
    }

    public T initialPoolSize(Integer value) {
        Integer oldValue = this.initialPoolSize;
        this.initialPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jta")
    public Boolean jta() {
        return this.jta;
    }

    public T jta(Boolean value) {
        Boolean oldValue = this.jta;
        this.jta = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jta", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-pool-size")
    public Integer maxPoolSize() {
        return this.maxPoolSize;
    }

    public T maxPoolSize(Integer value) {
        Integer oldValue = this.maxPoolSize;
        this.maxPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mcp")
    public String mcp() {
        return this.mcp;
    }

    public T mcp(String value) {
        String oldValue = this.mcp;
        this.mcp = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mcp", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-pool-size")
    public Integer minPoolSize() {
        return this.minPoolSize;
    }

    public T minPoolSize(Integer value) {
        Integer oldValue = this.minPoolSize;
        this.minPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="new-connection-sql")
    public String newConnectionSql() {
        return this.newConnectionSql;
    }

    public T newConnectionSql(String value) {
        String oldValue = this.newConnectionSql;
        this.newConnectionSql = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("newConnectionSql", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="password")
    public String password() {
        return this.password;
    }

    public T password(String value) {
        String oldValue = this.password;
        this.password = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("password", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-fair")
    public Boolean poolFair() {
        return this.poolFair;
    }

    public T poolFair(Boolean value) {
        Boolean oldValue = this.poolFair;
        this.poolFair = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolFair", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-prefill")
    public Boolean poolPrefill() {
        return this.poolPrefill;
    }

    public T poolPrefill(Boolean value) {
        Boolean oldValue = this.poolPrefill;
        this.poolPrefill = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolPrefill", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-use-strict-min")
    public Boolean poolUseStrictMin() {
        return this.poolUseStrictMin;
    }

    public T poolUseStrictMin(Boolean value) {
        Boolean oldValue = this.poolUseStrictMin;
        this.poolUseStrictMin = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolUseStrictMin", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="prepared-statements-cache-size")
    public Long preparedStatementsCacheSize() {
        return this.preparedStatementsCacheSize;
    }

    public T preparedStatementsCacheSize(Long value) {
        Long oldValue = this.preparedStatementsCacheSize;
        this.preparedStatementsCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preparedStatementsCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="query-timeout")
    public Long queryTimeout() {
        return this.queryTimeout;
    }

    public T queryTimeout(Long value) {
        Long oldValue = this.queryTimeout;
        this.queryTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queryTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reauth-plugin-class-name")
    public String reauthPluginClassName() {
        return this.reauthPluginClassName;
    }

    public T reauthPluginClassName(String value) {
        String oldValue = this.reauthPluginClassName;
        this.reauthPluginClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reauthPluginClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reauth-plugin-properties")
    public Map reauthPluginProperties() {
        return this.reauthPluginProperties;
    }

    public T reauthPluginProperties(Map value) {
        Map oldValue = this.reauthPluginProperties;
        this.reauthPluginProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reauthPluginProperties", oldValue, value);
        }
        return (T)this;
    }

    public T reauthPluginProperty(String key, Object value) {
        if (this.reauthPluginProperties == null) {
            this.reauthPluginProperties = new HashMap();
        }
        this.reauthPluginProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="set-tx-query-timeout")
    public Boolean setTxQueryTimeout() {
        return this.setTxQueryTimeout;
    }

    public T setTxQueryTimeout(Boolean value) {
        Boolean oldValue = this.setTxQueryTimeout;
        this.setTxQueryTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("setTxQueryTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="share-prepared-statements")
    public Boolean sharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public T sharePreparedStatements(Boolean value) {
        Boolean oldValue = this.sharePreparedStatements;
        this.sharePreparedStatements = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sharePreparedStatements", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="spy")
    public Boolean spy() {
        return this.spy;
    }

    public T spy(Boolean value) {
        Boolean oldValue = this.spy;
        this.spy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("spy", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stale-connection-checker-class-name")
    public String staleConnectionCheckerClassName() {
        return this.staleConnectionCheckerClassName;
    }

    public T staleConnectionCheckerClassName(String value) {
        String oldValue = this.staleConnectionCheckerClassName;
        this.staleConnectionCheckerClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("staleConnectionCheckerClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stale-connection-checker-properties")
    public Map staleConnectionCheckerProperties() {
        return this.staleConnectionCheckerProperties;
    }

    public T staleConnectionCheckerProperties(Map value) {
        Map oldValue = this.staleConnectionCheckerProperties;
        this.staleConnectionCheckerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("staleConnectionCheckerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T staleConnectionCheckerProperty(String key, Object value) {
        if (this.staleConnectionCheckerProperties == null) {
            this.staleConnectionCheckerProperties = new HashMap();
        }
        this.staleConnectionCheckerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="track-statements")
    public String trackStatements() {
        return this.trackStatements;
    }

    public T trackStatements(String value) {
        String oldValue = this.trackStatements;
        this.trackStatements = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trackStatements", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tracking")
    public Boolean tracking() {
        return this.tracking;
    }

    public T tracking(Boolean value) {
        Boolean oldValue = this.tracking;
        this.tracking = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tracking", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transaction-isolation")
    public String transactionIsolation() {
        return this.transactionIsolation;
    }

    public T transactionIsolation(String value) {
        String oldValue = this.transactionIsolation;
        this.transactionIsolation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transactionIsolation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-delimiter")
    public String urlDelimiter() {
        return this.urlDelimiter;
    }

    public T urlDelimiter(String value) {
        String oldValue = this.urlDelimiter;
        this.urlDelimiter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlDelimiter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-selector-strategy-class-name")
    public String urlSelectorStrategyClassName() {
        return this.urlSelectorStrategyClassName;
    }

    public T urlSelectorStrategyClassName(String value) {
        String oldValue = this.urlSelectorStrategyClassName;
        this.urlSelectorStrategyClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlSelectorStrategyClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-ccm")
    public Boolean useCcm() {
        return this.useCcm;
    }

    public T useCcm(Boolean value) {
        Boolean oldValue = this.useCcm;
        this.useCcm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useCcm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-fast-fail")
    public Boolean useFastFail() {
        return this.useFastFail;
    }

    public T useFastFail(Boolean value) {
        Boolean oldValue = this.useFastFail;
        this.useFastFail = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useFastFail", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-java-context")
    public Boolean useJavaContext() {
        return this.useJavaContext;
    }

    public T useJavaContext(Boolean value) {
        Boolean oldValue = this.useJavaContext;
        this.useJavaContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useJavaContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-try-lock")
    public Long useTryLock() {
        return this.useTryLock;
    }

    public T useTryLock(Long value) {
        Long oldValue = this.useTryLock;
        this.useTryLock = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useTryLock", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="user-name")
    public String userName() {
        return this.userName;
    }

    public T userName(String value) {
        String oldValue = this.userName;
        this.userName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("userName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="valid-connection-checker-class-name")
    public String validConnectionCheckerClassName() {
        return this.validConnectionCheckerClassName;
    }

    public T validConnectionCheckerClassName(String value) {
        String oldValue = this.validConnectionCheckerClassName;
        this.validConnectionCheckerClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validConnectionCheckerClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="valid-connection-checker-properties")
    public Map validConnectionCheckerProperties() {
        return this.validConnectionCheckerProperties;
    }

    public T validConnectionCheckerProperties(Map value) {
        Map oldValue = this.validConnectionCheckerProperties;
        this.validConnectionCheckerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validConnectionCheckerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T validConnectionCheckerProperty(String key, Object value) {
        if (this.validConnectionCheckerProperties == null) {
            this.validConnectionCheckerProperties = new HashMap();
        }
        this.validConnectionCheckerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="validate-on-match")
    public Boolean validateOnMatch() {
        return this.validateOnMatch;
    }

    public T validateOnMatch(Boolean value) {
        Boolean oldValue = this.validateOnMatch;
        this.validateOnMatch = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validateOnMatch", oldValue, value);
        }
        return (T)this;
    }

    public static class DataSourceResources {
        @ResourceDocumentation(value="The connection-properties element allows you to pass in arbitrary connection properties to the Driver.connect(url, props) method")
        @SubresourceInfo(value="connectionProperties")
        private List<ConnectionProperties> connectionProperties = new ArrayList<ConnectionProperties>();

        @Subresource
        public List<ConnectionProperties> connectionProperties() {
            return this.connectionProperties;
        }

        public ConnectionProperties connectionProperties(String key) {
            return this.connectionProperties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

