/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.datasources;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=datasources/jdbc-driver=*")
@ResourceType(value="jdbc-driver")
public class JDBCDriver<T extends JDBCDriver<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The available properties for the datasource-class, and xa-datasource-class for the jdbc-driver")
    private List<Object> datasourceClassInfo;
    @AttributeDocumentation(value="The name of the deployment unit from which the driver was loaded")
    private String deploymentName;
    @AttributeDocumentation(value="The fully qualified class name of the java.sql.Driver implementation")
    private String driverClassName;
    @AttributeDocumentation(value="The fully qualified class name of the javax.sql.DataSource implementation")
    private String driverDatasourceClassName;
    @AttributeDocumentation(value="The driver's major version number")
    private Integer driverMajorVersion;
    @AttributeDocumentation(value="The driver's minor version number")
    private Integer driverMinorVersion;
    @AttributeDocumentation(value="The name of the module from which the driver was loaded, if it was loaded from the module path")
    private String driverModuleName;
    @AttributeDocumentation(value="Defines the JDBC driver the datasource should use. It is a symbolic name matching the the name of installed driver. In case the driver is deployed as jar, the name is the name of deployment unit")
    private String driverName;
    @AttributeDocumentation(value="The fully qualified class name of the javax.sql.XADataSource implementation")
    private String driverXaDatasourceClassName;
    @AttributeDocumentation(value="Whether or not the driver is JDBC compliant")
    private Boolean jdbcCompliant;
    @AttributeDocumentation(value="The slot of the module from which the driver was loaded, if it was loaded from the module path")
    private String moduleSlot;
    @AttributeDocumentation(value="Domain Profile in which driver is defined. Null in case of standalone server")
    private String profile;
    @AttributeDocumentation(value="XA datasource class")
    private String xaDatasourceClass;

    public JDBCDriver(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="datasource-class-info")
    public List<Object> datasourceClassInfo() {
        return this.datasourceClassInfo;
    }

    public T datasourceClassInfo(List<Object> value) {
        List<Object> oldValue = this.datasourceClassInfo;
        this.datasourceClassInfo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("datasourceClassInfo", oldValue, value);
        }
        return (T)this;
    }

    public T datasourceClassInfo(Object value) {
        if (this.datasourceClassInfo == null) {
            this.datasourceClassInfo = new ArrayList<Object>();
        }
        this.datasourceClassInfo.add(value);
        return (T)this;
    }

    public T datasourceClassInfo(Object ... args) {
        this.datasourceClassInfo(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="deployment-name")
    public String deploymentName() {
        return this.deploymentName;
    }

    public T deploymentName(String value) {
        String oldValue = this.deploymentName;
        this.deploymentName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deploymentName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-class-name")
    public String driverClassName() {
        return this.driverClassName;
    }

    public T driverClassName(String value) {
        String oldValue = this.driverClassName;
        this.driverClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-datasource-class-name")
    public String driverDatasourceClassName() {
        return this.driverDatasourceClassName;
    }

    public T driverDatasourceClassName(String value) {
        String oldValue = this.driverDatasourceClassName;
        this.driverDatasourceClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverDatasourceClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-major-version")
    public Integer driverMajorVersion() {
        return this.driverMajorVersion;
    }

    public T driverMajorVersion(Integer value) {
        Integer oldValue = this.driverMajorVersion;
        this.driverMajorVersion = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverMajorVersion", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-minor-version")
    public Integer driverMinorVersion() {
        return this.driverMinorVersion;
    }

    public T driverMinorVersion(Integer value) {
        Integer oldValue = this.driverMinorVersion;
        this.driverMinorVersion = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverMinorVersion", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-module-name")
    public String driverModuleName() {
        return this.driverModuleName;
    }

    public T driverModuleName(String value) {
        String oldValue = this.driverModuleName;
        this.driverModuleName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverModuleName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-name")
    public String driverName() {
        return this.driverName;
    }

    public T driverName(String value) {
        String oldValue = this.driverName;
        this.driverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="driver-xa-datasource-class-name")
    public String driverXaDatasourceClassName() {
        return this.driverXaDatasourceClassName;
    }

    public T driverXaDatasourceClassName(String value) {
        String oldValue = this.driverXaDatasourceClassName;
        this.driverXaDatasourceClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("driverXaDatasourceClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-compliant")
    public Boolean jdbcCompliant() {
        return this.jdbcCompliant;
    }

    public T jdbcCompliant(Boolean value) {
        Boolean oldValue = this.jdbcCompliant;
        this.jdbcCompliant = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcCompliant", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module-slot")
    public String moduleSlot() {
        return this.moduleSlot;
    }

    public T moduleSlot(String value) {
        String oldValue = this.moduleSlot;
        this.moduleSlot = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("moduleSlot", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="profile")
    public String profile() {
        return this.profile;
    }

    public T profile(String value) {
        String oldValue = this.profile;
        this.profile = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("profile", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="xa-datasource-class")
    public String xaDatasourceClass() {
        return this.xaDatasourceClass;
    }

    public T xaDatasourceClass(String value) {
        String oldValue = this.xaDatasourceClass;
        this.xaDatasourceClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("xaDatasourceClass", oldValue, value);
        }
        return (T)this;
    }
}

