/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/authentication-context=*")
@ResourceType(value="authentication-context")
public class AuthenticationContext<T extends AuthenticationContext<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="A previously defined authentication context to extend.")
    private String attributeExtends;
    @AttributeDocumentation(value="The match-rules for this authentication context.")
    private List<Map> matchRules;

    public AuthenticationContext(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="extends")
    public String attributeExtends() {
        return this.attributeExtends;
    }

    public T attributeExtends(String value) {
        String oldValue = this.attributeExtends;
        this.attributeExtends = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeExtends", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="match-rules")
    public List<Map> matchRules() {
        return this.matchRules;
    }

    public T matchRules(List<Map> value) {
        List<Map> oldValue = this.matchRules;
        this.matchRules = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("matchRules", oldValue, value);
        }
        return (T)this;
    }

    public T matchRule(Map value) {
        if (this.matchRules == null) {
            this.matchRules = new ArrayList<Map>();
        }
        this.matchRules.add(value);
        return (T)this;
    }

    public T matchRules(Map ... args) {
        this.matchRules(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

