/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/http-authentication-factory=*")
@ResourceType(value="http-authentication-factory")
public class HTTPAuthenticationFactory<T extends HTTPAuthenticationFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The HTTP mechanisms available from this configuration after all filtering has been applied.")
    private List<String> availableMechanisms;
    @AttributeDocumentation(value="The HttpServerAuthenticationMechanismFactory to associate with this resource")
    private String httpServerMechanismFactory;
    @AttributeDocumentation(value="Mechanism specific configuration")
    private List<Map> mechanismConfigurations;
    @AttributeDocumentation(value="The SecurityDomain to associate with this resource")
    private String securityDomain;

    public HTTPAuthenticationFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="available-mechanisms")
    public List<String> availableMechanisms() {
        return this.availableMechanisms;
    }

    public T availableMechanisms(List<String> value) {
        List<String> oldValue = this.availableMechanisms;
        this.availableMechanisms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
        }
        return (T)this;
    }

    public T availableMechanism(String value) {
        if (this.availableMechanisms == null) {
            this.availableMechanisms = new ArrayList<String>();
        }
        this.availableMechanisms.add(value);
        return (T)this;
    }

    public T availableMechanisms(String ... args) {
        this.availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="http-server-mechanism-factory")
    public String httpServerMechanismFactory() {
        return this.httpServerMechanismFactory;
    }

    public T httpServerMechanismFactory(String value) {
        String oldValue = this.httpServerMechanismFactory;
        this.httpServerMechanismFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("httpServerMechanismFactory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mechanism-configurations")
    public List<Map> mechanismConfigurations() {
        return this.mechanismConfigurations;
    }

    public T mechanismConfigurations(List<Map> value) {
        List<Map> oldValue = this.mechanismConfigurations;
        this.mechanismConfigurations = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mechanismConfigurations", oldValue, value);
        }
        return (T)this;
    }

    public T mechanismConfiguration(Map value) {
        if (this.mechanismConfigurations == null) {
            this.mechanismConfigurations = new ArrayList<Map>();
        }
        this.mechanismConfigurations.add(value);
        return (T)this;
    }

    public T mechanismConfigurations(Map ... args) {
        this.mechanismConfigurations(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }
}

