/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/key-manager=*")
@ResourceType(value="key-manager")
public class KeyManager<T extends KeyManager<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the algorithm to use to create the underlying KeyManagerFactory.")
    private String algorithm;
    @AttributeDocumentation(value="A filter to apply to the aliases returned from the KeyStore, can either be a comma separated list of aliases to return or one of the following formats ALL:-alias1:-alias2, NONE:+alias1:+alias2")
    private String aliasFilter;
    @AttributeDocumentation(value="The credential reference to decrypt KeyStore item. (Not a password of the KeyStore.)")
    private Map credentialReference;
    @AttributeDocumentation(value="Reference to the KeyStore to use to initialise the underlying KeyManagerFactory.")
    private String keyStore;
    @AttributeDocumentation(value="The name of the provider to use to create the underlying KeyManagerFactory.")
    private String providerName;
    @AttributeDocumentation(value="Reference to obtain the Provider[] to use when creating the underlying KeyManagerFactory.")
    private String providers;

    public KeyManager(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="algorithm")
    public String algorithm() {
        return this.algorithm;
    }

    public T algorithm(String value) {
        String oldValue = this.algorithm;
        this.algorithm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("algorithm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="alias-filter")
    public String aliasFilter() {
        return this.aliasFilter;
    }

    public T aliasFilter(String value) {
        String oldValue = this.aliasFilter;
        this.aliasFilter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("aliasFilter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="credential-reference")
    public Map credentialReference() {
        return this.credentialReference;
    }

    public T credentialReference(Map value) {
        Map oldValue = this.credentialReference;
        this.credentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("credentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T credentialReference(String key, Object value) {
        if (this.credentialReference == null) {
            this.credentialReference = new HashMap();
        }
        this.credentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-store")
    public String keyStore() {
        return this.keyStore;
    }

    public T keyStore(String value) {
        String oldValue = this.keyStore;
        this.keyStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="provider-name")
    public String providerName() {
        return this.providerName;
    }

    public T providerName(String value) {
        String oldValue = this.providerName;
        this.providerName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providerName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="providers")
    public String providers() {
        return this.providers;
    }

    public T providers(String value) {
        String oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }
}

