/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/mapped-regex-realm-mapper=*")
@ResourceType(value="mapped-regex-realm-mapper")
public class MappedRegexRealmMapper<T extends MappedRegexRealmMapper<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The RealmMapper to delegate to if the pattern does not match. If no delegate is specified then the default realm on the domain will be used instead. If the username does not match the pattern and a delegate realm-mapper is present, the result of delegate-realm-mapper is mapped via the realm-map.")
    private String delegateRealmMapper;
    @AttributeDocumentation(value="The regular expression which must contain at least one capture group to extract the realm from the name. If the regular expression matches more than one capture group, the first capture group is used.")
    private String pattern;
    @AttributeDocumentation(value="Mapping of realm name extracted using the regular expression to a defined realm name. If the value for the mapping is not in the map or the realm whose name is the result of the mapping does not exist in the given security domain, the default realm is used.")
    private Map realmMap;

    public MappedRegexRealmMapper(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="delegate-realm-mapper")
    public String delegateRealmMapper() {
        return this.delegateRealmMapper;
    }

    public T delegateRealmMapper(String value) {
        String oldValue = this.delegateRealmMapper;
        this.delegateRealmMapper = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("delegateRealmMapper", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pattern")
    public String pattern() {
        return this.pattern;
    }

    public T pattern(String value) {
        String oldValue = this.pattern;
        this.pattern = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("pattern", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm-map")
    public Map realmMap() {
        return this.realmMap;
    }

    public T realmMap(Map value) {
        Map oldValue = this.realmMap;
        this.realmMap = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realmMap", oldValue, value);
        }
        return (T)this;
    }

    public T realmMap(String key, Object value) {
        if (this.realmMap == null) {
            this.realmMap = new HashMap();
        }
        this.realmMap.put(key, value);
        return (T)this;
    }
}

