/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.elytron.SslSession;
import org.wildfly.swarm.config.elytron.SslSessionConsumer;
import org.wildfly.swarm.config.elytron.SslSessionSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=elytron/server-ssl-context=*")
@ResourceType(value="server-ssl-context")
public class ServerSslContext<T extends ServerSslContext<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ServerSslContextResources subresources = new ServerSslContextResources();
    @AttributeDocumentation(value="The count of current active sessions.")
    private Integer activeSessionCount;
    @AttributeDocumentation(value="Rejecting of the client certificate by the security domain will not prevent the connection. Allows a fall through to use other authentication mechanisms (like form login) when the client certificate is rejected by security domain. Has an effect only when the security domain is set.")
    private Boolean authenticationOptional;
    @AttributeDocumentation(value="The filter to apply to specify the enabled cipher suites.")
    private String cipherSuiteFilter;
    @AttributeDocumentation(value="A final principal transformer to apply for this mechanism realm.")
    private String finalPrincipalTransformer;
    @AttributeDocumentation(value="Reference to the key manager to use within the SSLContext.")
    private String keyManager;
    @AttributeDocumentation(value="The maximum number of SSL sessions in the cache. The default value -1 means use the JVM default value. Value zero means there is no limit.")
    private Integer maximumSessionCacheSize;
    @AttributeDocumentation(value="To require a client certificate on SSL handshake. Connection without trusted client certificate (see trust-manager) will be rejected.")
    private Boolean needClientAuth;
    @AttributeDocumentation(value="A principal transformer to apply after the realm is selected.")
    private String postRealmPrincipalTransformer;
    @AttributeDocumentation(value="A principal transformer to apply before the realm is selected.")
    private String preRealmPrincipalTransformer;
    @AttributeDocumentation(value="The enabled protocols.")
    private List<String> protocols;
    @AttributeDocumentation(value="The name of the provider to use. If not specified, all providers from providers will be passed to the SSLContext.")
    private String providerName;
    @AttributeDocumentation(value="The name of the providers to obtain the Provider[] to use to load the SSLContext.")
    private String providers;
    @AttributeDocumentation(value="The realm mapper to be used for SSL authentication.")
    private String realmMapper;
    @AttributeDocumentation(value="The security domain to use for authentication during SSL session establishment.")
    private String securityDomain;
    @AttributeDocumentation(value="The timeout for SSL sessions, in seconds. The default value -1 means use the JVM default value. Value zero means there is no limit.")
    private Integer sessionTimeout;
    @AttributeDocumentation(value="Reference to the trust manager to use within the SSLContext.")
    private String trustManager;
    @AttributeDocumentation(value="To honor local cipher suites preference.")
    private Boolean useCipherSuitesOrder;
    @AttributeDocumentation(value="To request (but not to require) a client certificate on SSL handshake. If a security domain is referenced and supports X509 evidence, this will be set to true automatically. Ignored when need-client-auth is set.")
    private Boolean wantClientAuth;
    @AttributeDocumentation(value="Should the SSLEngine, SSLSocket, and SSLServerSocket instances returned be wrapped to protect against further modification.")
    private Boolean wrap;

    public ServerSslContext(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ServerSslContextResources subresources() {
        return this.subresources;
    }

    public T sslSessions(List<SslSession> value) {
        this.subresources.sslSessions = value;
        return (T)this;
    }

    public T sslSession(SslSession value) {
        this.subresources.sslSessions.add(value);
        return (T)this;
    }

    public T sslSession(String childKey, SslSessionConsumer consumer) {
        SslSession child = new SslSession(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.sslSession(child);
        return (T)this;
    }

    public T sslSession(String childKey) {
        this.sslSession(childKey, null);
        return (T)this;
    }

    public T sslSession(SslSessionSupplier supplier) {
        this.sslSession(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="active-session-count")
    public Integer activeSessionCount() {
        return this.activeSessionCount;
    }

    public T activeSessionCount(Integer value) {
        Integer oldValue = this.activeSessionCount;
        this.activeSessionCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("activeSessionCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-optional")
    public Boolean authenticationOptional() {
        return this.authenticationOptional;
    }

    public T authenticationOptional(Boolean value) {
        Boolean oldValue = this.authenticationOptional;
        this.authenticationOptional = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationOptional", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cipher-suite-filter")
    public String cipherSuiteFilter() {
        return this.cipherSuiteFilter;
    }

    public T cipherSuiteFilter(String value) {
        String oldValue = this.cipherSuiteFilter;
        this.cipherSuiteFilter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cipherSuiteFilter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="final-principal-transformer")
    public String finalPrincipalTransformer() {
        return this.finalPrincipalTransformer;
    }

    public T finalPrincipalTransformer(String value) {
        String oldValue = this.finalPrincipalTransformer;
        this.finalPrincipalTransformer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("finalPrincipalTransformer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-manager")
    public String keyManager() {
        return this.keyManager;
    }

    public T keyManager(String value) {
        String oldValue = this.keyManager;
        this.keyManager = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyManager", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="maximum-session-cache-size")
    public Integer maximumSessionCacheSize() {
        return this.maximumSessionCacheSize;
    }

    public T maximumSessionCacheSize(Integer value) {
        Integer oldValue = this.maximumSessionCacheSize;
        this.maximumSessionCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maximumSessionCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="need-client-auth")
    public Boolean needClientAuth() {
        return this.needClientAuth;
    }

    public T needClientAuth(Boolean value) {
        Boolean oldValue = this.needClientAuth;
        this.needClientAuth = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("needClientAuth", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="post-realm-principal-transformer")
    public String postRealmPrincipalTransformer() {
        return this.postRealmPrincipalTransformer;
    }

    public T postRealmPrincipalTransformer(String value) {
        String oldValue = this.postRealmPrincipalTransformer;
        this.postRealmPrincipalTransformer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("postRealmPrincipalTransformer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pre-realm-principal-transformer")
    public String preRealmPrincipalTransformer() {
        return this.preRealmPrincipalTransformer;
    }

    public T preRealmPrincipalTransformer(String value) {
        String oldValue = this.preRealmPrincipalTransformer;
        this.preRealmPrincipalTransformer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preRealmPrincipalTransformer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocols")
    public List<String> protocols() {
        return this.protocols;
    }

    public T protocols(List<String> value) {
        List<String> oldValue = this.protocols;
        this.protocols = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocols", oldValue, value);
        }
        return (T)this;
    }

    public T protocol(String value) {
        if (this.protocols == null) {
            this.protocols = new ArrayList<String>();
        }
        this.protocols.add(value);
        return (T)this;
    }

    public T protocols(String ... args) {
        this.protocols(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="provider-name")
    public String providerName() {
        return this.providerName;
    }

    public T providerName(String value) {
        String oldValue = this.providerName;
        this.providerName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providerName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="providers")
    public String providers() {
        return this.providers;
    }

    public T providers(String value) {
        String oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="realm-mapper")
    public String realmMapper() {
        return this.realmMapper;
    }

    public T realmMapper(String value) {
        String oldValue = this.realmMapper;
        this.realmMapper = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("realmMapper", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="session-timeout")
    public Integer sessionTimeout() {
        return this.sessionTimeout;
    }

    public T sessionTimeout(Integer value) {
        Integer oldValue = this.sessionTimeout;
        this.sessionTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sessionTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="trust-manager")
    public String trustManager() {
        return this.trustManager;
    }

    public T trustManager(String value) {
        String oldValue = this.trustManager;
        this.trustManager = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("trustManager", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-cipher-suites-order")
    public Boolean useCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public T useCipherSuitesOrder(Boolean value) {
        Boolean oldValue = this.useCipherSuitesOrder;
        this.useCipherSuitesOrder = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useCipherSuitesOrder", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="want-client-auth")
    public Boolean wantClientAuth() {
        return this.wantClientAuth;
    }

    public T wantClientAuth(Boolean value) {
        Boolean oldValue = this.wantClientAuth;
        this.wantClientAuth = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wantClientAuth", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wrap")
    public Boolean wrap() {
        return this.wrap;
    }

    public T wrap(Boolean value) {
        Boolean oldValue = this.wrap;
        this.wrap = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wrap", oldValue, value);
        }
        return (T)this;
    }

    public static class ServerSslContextResources {
        @ResourceDocumentation(value="A currently established SSL session.")
        @SubresourceInfo(value="sslSession")
        private List<SslSession> sslSessions = new ArrayList<SslSession>();

        @Subresource
        public List<SslSession> sslSessions() {
            return this.sslSessions;
        }

        public SslSession sslSession(String key) {
            return this.sslSessions.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

