/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/token-realm=*")
@ResourceType(value="token-realm")
public class TokenRealm<T extends TokenRealm<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="A token validator to be used in conjunction with a token-based realm that handles security tokens based on the JWT/JWS standard.")
    private Map jwt;
    @AttributeDocumentation(value="A token validator to be used in conjunction with a token-based realm that handles OAuth2 Access Tokens and validates them using an endpoint compliant with OAuth2 Token Introspection specification(RFC-7662).")
    private Map oauth2Introspection;
    @AttributeDocumentation(value="The name of the claim that should be used to obtain the principal's name.")
    private String principalClaim;

    public TokenRealm(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="jwt")
    public Map jwt() {
        return this.jwt;
    }

    public T jwt(Map value) {
        Map oldValue = this.jwt;
        this.jwt = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jwt", oldValue, value);
        }
        return (T)this;
    }

    public T jwt(String key, Object value) {
        if (this.jwt == null) {
            this.jwt = new HashMap();
        }
        this.jwt.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="oauth2-introspection")
    public Map oauth2Introspection() {
        return this.oauth2Introspection;
    }

    public T oauth2Introspection(Map value) {
        Map oldValue = this.oauth2Introspection;
        this.oauth2Introspection = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("oauth2Introspection", oldValue, value);
        }
        return (T)this;
    }

    public T oauth2Introspection(String key, Object value) {
        if (this.oauth2Introspection == null) {
            this.oauth2Introspection = new HashMap();
        }
        this.oauth2Introspection.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="principal-claim")
    public String principalClaim() {
        return this.principalClaim;
    }

    public T principalClaim(String value) {
        String oldValue = this.principalClaim;
        this.principalClaim = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("principalClaim", oldValue, value);
        }
        return (T)this;
    }
}

