/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.logging.ExceptionOutputType;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=logging/json-formatter=*", "/subsystem=logging/logging-profile=*/json-formatter=*"})
@ResourceType(value="json-formatter")
public class JsonFormatter<T extends JsonFormatter<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The date/time format pattern. The pattern must be a valid java.time.format.DateTimeFormatter.ofPattern() pattern. The default pattern is an ISO-8601 extended offset date-time format.")
    private String dateFormat;
    @AttributeDocumentation(value="Indicates how the cause of the logged message, if one is available, will be added to the JSON output.")
    private ExceptionOutputType exceptionOutputType;
    @AttributeDocumentation(value="Allows the names of the keys for the JSON properties to be overridden.")
    private Map keyOverrides;
    @AttributeDocumentation(value="Sets the meta data to use in the JSON format. Properties will be added to each log message.")
    private Map metaData;
    @AttributeDocumentation(value="Indicates whether or not pretty printing should be used when formatting.")
    private Boolean prettyPrint;
    @AttributeDocumentation(value="Sets whether or not details should be printed. Printing the details can be expensive as the values are retrieved from the caller. The details include the source class name, source file name, source method name, source module name, source module version and source line number.")
    private Boolean printDetails;
    @AttributeDocumentation(value="The value to be used to indicate the end of a record. If set to null no delimiter will be used at the end of the record. The default value is a line feed.")
    private String recordDelimiter;
    @AttributeDocumentation(value="The zone ID for formatting the date and time. The system default is used if left undefined.")
    private String zoneId;

    public JsonFormatter(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="date-format")
    public String dateFormat() {
        return this.dateFormat;
    }

    public T dateFormat(String value) {
        String oldValue = this.dateFormat;
        this.dateFormat = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dateFormat", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exception-output-type")
    public ExceptionOutputType exceptionOutputType() {
        return this.exceptionOutputType;
    }

    public T exceptionOutputType(ExceptionOutputType value) {
        ExceptionOutputType oldValue = this.exceptionOutputType;
        this.exceptionOutputType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exceptionOutputType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-overrides")
    public Map keyOverrides() {
        return this.keyOverrides;
    }

    public T keyOverrides(Map value) {
        Map oldValue = this.keyOverrides;
        this.keyOverrides = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyOverrides", oldValue, value);
        }
        return (T)this;
    }

    public T keyOverride(String key, Object value) {
        if (this.keyOverrides == null) {
            this.keyOverrides = new HashMap();
        }
        this.keyOverrides.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="meta-data")
    public Map metaData() {
        return this.metaData;
    }

    public T metaData(Map value) {
        Map oldValue = this.metaData;
        this.metaData = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("metaData", oldValue, value);
        }
        return (T)this;
    }

    public T metaDatum(String key, Object value) {
        if (this.metaData == null) {
            this.metaData = new HashMap();
        }
        this.metaData.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pretty-print")
    public Boolean prettyPrint() {
        return this.prettyPrint;
    }

    public T prettyPrint(Boolean value) {
        Boolean oldValue = this.prettyPrint;
        this.prettyPrint = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("prettyPrint", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="print-details")
    public Boolean printDetails() {
        return this.printDetails;
    }

    public T printDetails(Boolean value) {
        Boolean oldValue = this.printDetails;
        this.printDetails = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("printDetails", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="record-delimiter")
    public String recordDelimiter() {
        return this.recordDelimiter;
    }

    public T recordDelimiter(String value) {
        String oldValue = this.recordDelimiter;
        this.recordDelimiter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recordDelimiter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="zone-id")
    public String zoneId() {
        return this.zoneId;
    }

    public T zoneId(String value) {
        String oldValue = this.zoneId;
        this.zoneId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("zoneId", oldValue, value);
        }
        return (T)this;
    }
}

