/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=logging/socket-handler=*", "/subsystem=logging/logging-profile=*/socket-handler=*"})
@ResourceType(value="socket-handler")
public class SocketHandler<T extends SocketHandler<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Automatically flush after each write.")
    private Boolean autoflush;
    @AttributeDocumentation(value="If set to true the write methods will block when attempting to reconnect. This is only advisable to be set to true if using an asynchronous handler.")
    private Boolean blockOnReconnect;
    @AttributeDocumentation(value="If set to true the handler is enabled and functioning as normal, if set to false the handler is ignored when processing log messages.")
    private Boolean enabled;
    @AttributeDocumentation(value="The character encoding used by this Handler.")
    private String encoding;
    @AttributeDocumentation(value="A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match(\"JBAS.*\"))")
    private String filterSpec;
    @AttributeDocumentation(value="The log level specifying which message levels will be logged by this logger. Message levels lower than this value will be discarded.")
    private Level level;
    @AttributeDocumentation(value="The name of the defined formatter to be used on the handler.")
    private String namedFormatter;
    @AttributeDocumentation(value="Outbound socket reference for the socket connection.")
    private String outboundSocketBindingRef;
    @AttributeDocumentation(value="The protocol the socket should communicate over.")
    private Protocol protocol;
    @AttributeDocumentation(value="The reference to the defined SSL context. This is only used if the protocol is set to SSL_TCP.")
    private String sslContext;

    public SocketHandler(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="autoflush")
    public Boolean autoflush() {
        return this.autoflush;
    }

    public T autoflush(Boolean value) {
        Boolean oldValue = this.autoflush;
        this.autoflush = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autoflush", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="block-on-reconnect")
    public Boolean blockOnReconnect() {
        return this.blockOnReconnect;
    }

    public T blockOnReconnect(Boolean value) {
        Boolean oldValue = this.blockOnReconnect;
        this.blockOnReconnect = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("blockOnReconnect", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="encoding")
    public String encoding() {
        return this.encoding;
    }

    public T encoding(String value) {
        String oldValue = this.encoding;
        this.encoding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("encoding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter-spec")
    public String filterSpec() {
        return this.filterSpec;
    }

    public T filterSpec(String value) {
        String oldValue = this.filterSpec;
        this.filterSpec = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filterSpec", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="level")
    public Level level() {
        return this.level;
    }

    public T level(Level value) {
        Level oldValue = this.level;
        this.level = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("level", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="named-formatter")
    public String namedFormatter() {
        return this.namedFormatter;
    }

    public T namedFormatter(String value) {
        String oldValue = this.namedFormatter;
        this.namedFormatter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("namedFormatter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="outbound-socket-binding-ref")
    public String outboundSocketBindingRef() {
        return this.outboundSocketBindingRef;
    }

    public T outboundSocketBindingRef(String value) {
        String oldValue = this.outboundSocketBindingRef;
        this.outboundSocketBindingRef = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("outboundSocketBindingRef", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol")
    public Protocol protocol() {
        return this.protocol;
    }

    public T protocol(Protocol value) {
        Protocol oldValue = this.protocol;
        this.protocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocol", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-context")
    public String sslContext() {
        return this.sslContext;
    }

    public T sslContext(String value) {
        String oldValue = this.sslContext;
        this.sslContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslContext", oldValue, value);
        }
        return (T)this;
    }

    public static enum Protocol {
        TCP("TCP"),
        UDP("UDP"),
        SSL_TCP("SSL_TCP");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Protocol(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

