/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/broadcast-group=*")
@ResourceType(value="broadcast-group")
public class BroadcastGroup<T extends BroadcastGroup<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The period in milliseconds between consecutive broadcasts.")
    private Long broadcastPeriod;
    @AttributeDocumentation(value="Specifies the names of connectors that will be broadcast.")
    private List<String> connectors;
    @AttributeDocumentation(value="References the name of a JGroups channel.  If undefined, the default channel will be used.")
    private String jgroupsChannel;
    @AttributeDocumentation(value="The logical cluster name.")
    private String jgroupsCluster;
    @AttributeDocumentation(value="The broadcast group socket binding.")
    private String socketBinding;
    @AttributeDocumentation(value="Whether the broadcast group is started.")
    private Boolean started;

    public BroadcastGroup(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="broadcast-period")
    public Long broadcastPeriod() {
        return this.broadcastPeriod;
    }

    public T broadcastPeriod(Long value) {
        Long oldValue = this.broadcastPeriod;
        this.broadcastPeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("broadcastPeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connectors")
    public List<String> connectors() {
        return this.connectors;
    }

    public T connectors(List<String> value) {
        List<String> oldValue = this.connectors;
        this.connectors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectors", oldValue, value);
        }
        return (T)this;
    }

    public T connector(String value) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<String>();
        }
        this.connectors.add(value);
        return (T)this;
    }

    public T connectors(String ... args) {
        this.connectors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jgroups-channel")
    public String jgroupsChannel() {
        return this.jgroupsChannel;
    }

    public T jgroupsChannel(String value) {
        String oldValue = this.jgroupsChannel;
        this.jgroupsChannel = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jgroupsChannel", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jgroups-cluster")
    public String jgroupsCluster() {
        return this.jgroupsCluster;
    }

    public T jgroupsCluster(String value) {
        String oldValue = this.jgroupsCluster;
        this.jgroupsCluster = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jgroupsCluster", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="started")
    public Boolean started() {
        return this.started;
    }

    public T started(Boolean value) {
        Boolean oldValue = this.started;
        this.started = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("started", oldValue, value);
        }
        return (T)this;
    }
}

