/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/cluster-connection=*")
@ResourceType(value="cluster-connection")
public class ClusterConnection<T extends ClusterConnection<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Whether, if a node learns of the existence of a node that is more than 1 hop away, we do not create a bridge for direct cluster connection. Only relevant if 'static-connectors' is defined.")
    private Boolean allowDirectConnectionsOnly;
    @AttributeDocumentation(value="The timeout to use when fail over is in process (in ms) for remote calls made by the cluster connection.")
    private Long callFailoverTimeout;
    @AttributeDocumentation(value="The timeout (in ms) for remote calls made by the cluster connection.")
    private Long callTimeout;
    @AttributeDocumentation(value="The period (in milliseconds) between client failure check.")
    private Long checkPeriod;
    @AttributeDocumentation(value="Each cluster connection only applies to messages sent to an address that starts with this value.")
    private String clusterConnectionAddress;
    @AttributeDocumentation(value="The confirmation-window-size to use for the connection used to forward messages to a target node.")
    private Integer confirmationWindowSize;
    @AttributeDocumentation(value="The maximum time (in milliseconds) for which the connections used by the cluster connections are considered alive (in the absence of heartbeat).")
    private Long connectionTtl;
    @AttributeDocumentation(value="The name of connector to use for live connection")
    private String connectorName;
    @AttributeDocumentation(value="The discovery group used to obtain the list of other servers in the cluster to which this cluster connection will make connections. Must be undefined (null) if 'static-connectors' is defined.")
    private String discoveryGroup;
    @AttributeDocumentation(value="The number of attempts to connect initially with this cluster connection.")
    private Integer initialConnectAttempts;
    @AttributeDocumentation(value="The maximum number of times a message can be forwarded. ActiveMQ can be configured to also load balance messages to nodes which might be connected to it only indirectly with other ActiveMQ servers as intermediates in a chain.")
    private Integer maxHops;
    @AttributeDocumentation(value="The maximum interval of time used to retry connections")
    private Long maxRetryInterval;
    @AttributeDocumentation(value="The type of message load balancing provided by the cluster connection.")
    private MessageLoadBalancingType messageLoadBalancingType;
    @AttributeDocumentation(value="The minimum size (in bytes) for a message before it is considered as a large message.")
    private Integer minLargeMessageSize;
    @AttributeDocumentation(value="The node ID used by this cluster connection.")
    private String nodeId;
    @AttributeDocumentation(value="How many times the cluster connection will broadcast itself")
    private Integer notificationAttempts;
    @AttributeDocumentation(value="How often the cluster connection will broadcast itself")
    private Long notificationInterval;
    @AttributeDocumentation(value="Producer flow control size on the cluster connection.")
    private Integer producerWindowSize;
    @AttributeDocumentation(value="The total number of reconnect attempts the bridge will make before giving up and shutting down. A value of -1 signifies an unlimited number of attempts.")
    private Integer reconnectAttempts;
    @AttributeDocumentation(value="The period in milliseconds between subsequent attempts to reconnect to a target server, if the connection to the target server has failed.")
    private Long retryInterval;
    @AttributeDocumentation(value="A multiplier to apply to the time since the last retry to compute the time to the next retry. This allows you to implement an exponential backoff between retry attempts.")
    private Double retryIntervalMultiplier;
    @AttributeDocumentation(value="Whether the cluster connection is started.")
    private Boolean started;
    @AttributeDocumentation(value="The statically defined list of connectors to which this cluster connection will make connections. Must be undefined (null) if 'discovery-group-name' is defined.")
    private List<String> staticConnectors;
    @AttributeDocumentation(value="The topology of the nodes that this cluster connection is aware of.")
    private String topology;
    @AttributeDocumentation(value="Whether the bridge will automatically insert a duplicate id property into each message that it forwards.")
    private Boolean useDuplicateDetection;

    public ClusterConnection(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="allow-direct-connections-only")
    public Boolean allowDirectConnectionsOnly() {
        return this.allowDirectConnectionsOnly;
    }

    public T allowDirectConnectionsOnly(Boolean value) {
        Boolean oldValue = this.allowDirectConnectionsOnly;
        this.allowDirectConnectionsOnly = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowDirectConnectionsOnly", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="call-failover-timeout")
    public Long callFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    public T callFailoverTimeout(Long value) {
        Long oldValue = this.callFailoverTimeout;
        this.callFailoverTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("callFailoverTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="call-timeout")
    public Long callTimeout() {
        return this.callTimeout;
    }

    public T callTimeout(Long value) {
        Long oldValue = this.callTimeout;
        this.callTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("callTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="check-period")
    public Long checkPeriod() {
        return this.checkPeriod;
    }

    public T checkPeriod(Long value) {
        Long oldValue = this.checkPeriod;
        this.checkPeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("checkPeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cluster-connection-address")
    public String clusterConnectionAddress() {
        return this.clusterConnectionAddress;
    }

    public T clusterConnectionAddress(String value) {
        String oldValue = this.clusterConnectionAddress;
        this.clusterConnectionAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clusterConnectionAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="confirmation-window-size")
    public Integer confirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public T confirmationWindowSize(Integer value) {
        Integer oldValue = this.confirmationWindowSize;
        this.confirmationWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("confirmationWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-ttl")
    public Long connectionTtl() {
        return this.connectionTtl;
    }

    public T connectionTtl(Long value) {
        Long oldValue = this.connectionTtl;
        this.connectionTtl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionTtl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connector-name")
    public String connectorName() {
        return this.connectorName;
    }

    public T connectorName(String value) {
        String oldValue = this.connectorName;
        this.connectorName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectorName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="discovery-group")
    public String discoveryGroup() {
        return this.discoveryGroup;
    }

    public T discoveryGroup(String value) {
        String oldValue = this.discoveryGroup;
        this.discoveryGroup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("discoveryGroup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initial-connect-attempts")
    public Integer initialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    public T initialConnectAttempts(Integer value) {
        Integer oldValue = this.initialConnectAttempts;
        this.initialConnectAttempts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialConnectAttempts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-hops")
    public Integer maxHops() {
        return this.maxHops;
    }

    public T maxHops(Integer value) {
        Integer oldValue = this.maxHops;
        this.maxHops = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxHops", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-retry-interval")
    public Long maxRetryInterval() {
        return this.maxRetryInterval;
    }

    public T maxRetryInterval(Long value) {
        Long oldValue = this.maxRetryInterval;
        this.maxRetryInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRetryInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-load-balancing-type")
    public MessageLoadBalancingType messageLoadBalancingType() {
        return this.messageLoadBalancingType;
    }

    public T messageLoadBalancingType(MessageLoadBalancingType value) {
        MessageLoadBalancingType oldValue = this.messageLoadBalancingType;
        this.messageLoadBalancingType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageLoadBalancingType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-large-message-size")
    public Integer minLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public T minLargeMessageSize(Integer value) {
        Integer oldValue = this.minLargeMessageSize;
        this.minLargeMessageSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minLargeMessageSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="node-id")
    public String nodeId() {
        return this.nodeId;
    }

    public T nodeId(String value) {
        String oldValue = this.nodeId;
        this.nodeId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nodeId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="notification-attempts")
    public Integer notificationAttempts() {
        return this.notificationAttempts;
    }

    public T notificationAttempts(Integer value) {
        Integer oldValue = this.notificationAttempts;
        this.notificationAttempts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("notificationAttempts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="notification-interval")
    public Long notificationInterval() {
        return this.notificationInterval;
    }

    public T notificationInterval(Long value) {
        Long oldValue = this.notificationInterval;
        this.notificationInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("notificationInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="producer-window-size")
    public Integer producerWindowSize() {
        return this.producerWindowSize;
    }

    public T producerWindowSize(Integer value) {
        Integer oldValue = this.producerWindowSize;
        this.producerWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("producerWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="reconnect-attempts")
    public Integer reconnectAttempts() {
        return this.reconnectAttempts;
    }

    public T reconnectAttempts(Integer value) {
        Integer oldValue = this.reconnectAttempts;
        this.reconnectAttempts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("reconnectAttempts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="retry-interval")
    public Long retryInterval() {
        return this.retryInterval;
    }

    public T retryInterval(Long value) {
        Long oldValue = this.retryInterval;
        this.retryInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("retryInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="retry-interval-multiplier")
    public Double retryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public T retryIntervalMultiplier(Double value) {
        Double oldValue = this.retryIntervalMultiplier;
        this.retryIntervalMultiplier = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("retryIntervalMultiplier", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="started")
    public Boolean started() {
        return this.started;
    }

    public T started(Boolean value) {
        Boolean oldValue = this.started;
        this.started = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("started", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="static-connectors")
    public List<String> staticConnectors() {
        return this.staticConnectors;
    }

    public T staticConnectors(List<String> value) {
        List<String> oldValue = this.staticConnectors;
        this.staticConnectors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("staticConnectors", oldValue, value);
        }
        return (T)this;
    }

    public T staticConnector(String value) {
        if (this.staticConnectors == null) {
            this.staticConnectors = new ArrayList<String>();
        }
        this.staticConnectors.add(value);
        return (T)this;
    }

    public T staticConnectors(String ... args) {
        this.staticConnectors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="topology")
    public String topology() {
        return this.topology;
    }

    public T topology(String value) {
        String oldValue = this.topology;
        this.topology = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("topology", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-duplicate-detection")
    public Boolean useDuplicateDetection() {
        return this.useDuplicateDetection;
    }

    public T useDuplicateDetection(Boolean value) {
        Boolean oldValue = this.useDuplicateDetection;
        this.useDuplicateDetection = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useDuplicateDetection", oldValue, value);
        }
        return (T)this;
    }

    public static enum MessageLoadBalancingType {
        OFF("OFF"),
        STRICT("STRICT"),
        ON_DEMAND("ON_DEMAND");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private MessageLoadBalancingType(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

