/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=security/elytron-key-store=*")
@ResourceType(value="elytron-key-store")
public class ElytronKeyStore<T extends ElytronKeyStore<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the legacy security domain that contains a JSSE configuration that can be used to export the key store.")
    private String legacyJsseConfig;

    public ElytronKeyStore(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="legacy-jsse-config")
    public String legacyJsseConfig() {
        return this.legacyJsseConfig;
    }

    public T legacyJsseConfig(String value) {
        String oldValue = this.legacyJsseConfig;
        this.legacyJsseConfig = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("legacyJsseConfig", oldValue, value);
        }
        return (T)this;
    }
}

