/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.manager;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=security-manager/deployment-permissions=default")
@ResourceType(value="deployment-permissions")
@Implicit
public class DefaultDeploymentPermissions<T extends DefaultDeploymentPermissions<T>>
implements Keyed {
    private String key = "default";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The maximum set of permissions that can be granted to a deployment or jars.")
    private List<Map> maximumPermissions;
    @AttributeDocumentation(value="The minimum set of permissions to be granted to a deployment or jars.")
    private List<Map> minimumPermissions;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="maximum-permissions")
    public List<Map> maximumPermissions() {
        return this.maximumPermissions;
    }

    public T maximumPermissions(List<Map> value) {
        List<Map> oldValue = this.maximumPermissions;
        this.maximumPermissions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maximumPermissions", oldValue, value);
        }
        return (T)this;
    }

    public T maximumPermission(Map value) {
        if (this.maximumPermissions == null) {
            this.maximumPermissions = new ArrayList<Map>();
        }
        this.maximumPermissions.add(value);
        return (T)this;
    }

    public T maximumPermissions(Map ... args) {
        this.maximumPermissions(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="minimum-permissions")
    public List<Map> minimumPermissions() {
        return this.minimumPermissions;
    }

    public T minimumPermissions(List<Map> value) {
        List<Map> oldValue = this.minimumPermissions;
        this.minimumPermissions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minimumPermissions", oldValue, value);
        }
        return (T)this;
    }

    public T minimumPermission(Map value) {
        if (this.minimumPermissions == null) {
            this.minimumPermissions = new ArrayList<Map>();
        }
        this.minimumPermissions.add(value);
        return (T)this;
    }

    public T minimumPermissions(Map ... args) {
        this.minimumPermissions(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

