/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.configuration.reverse_proxy.Host;
import org.wildfly.swarm.config.undertow.configuration.reverse_proxy.HostConsumer;
import org.wildfly.swarm.config.undertow.configuration.reverse_proxy.HostSupplier;

@Address(value="/subsystem=undertow/configuration=handler/reverse-proxy=*")
@ResourceType(value="reverse-proxy")
public class ReverseProxy<T extends ReverseProxy<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ReverseProxyResources subresources = new ReverseProxyResources();
    @AttributeDocumentation(value="The number of connections that will be kept alive indefinitely")
    private Integer cachedConnectionsPerThread;
    @AttributeDocumentation(value="The amount of time a connection can be idle before it will be closed. Connections will not time out once the pool size is down to the configured minimum (as configured by cached-connections-per-thread)")
    private Integer connectionIdleTimeout;
    @AttributeDocumentation(value="The number of connections that will be maintained to backend servers, per IO thread.")
    private Integer connectionsPerThread;
    @AttributeDocumentation(value="The maximum time that a proxy request can be active for, before being killed")
    private Integer maxRequestTime;
    @AttributeDocumentation(value="The number of times to attempt to retry a request if it fails. Note that if a request is not considered idempotent then it will only be retried if the proxy can be sure it was not sent to the backend server).")
    private Integer maxRetries;
    @AttributeDocumentation(value="Time in seconds to wait before attempting to reconnect to a server that is down")
    private Integer problemServerRetry;
    @AttributeDocumentation(value="The number of requests that can be queued if the connection pool is full before requests are rejected with a 503")
    private Integer requestQueueSize;
    @AttributeDocumentation(value="Comma separated list of session cookie names. Generally this will just be JSESSIONID.")
    private String sessionCookieNames;

    public ReverseProxy(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ReverseProxyResources subresources() {
        return this.subresources;
    }

    public T hosts(List<Host> value) {
        this.subresources.hosts = value;
        return (T)this;
    }

    public T host(Host value) {
        this.subresources.hosts.add(value);
        return (T)this;
    }

    public T host(String childKey, HostConsumer consumer) {
        Host child = new Host(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.host(child);
        return (T)this;
    }

    public T host(String childKey) {
        this.host(childKey, null);
        return (T)this;
    }

    public T host(HostSupplier supplier) {
        this.host(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cached-connections-per-thread")
    public Integer cachedConnectionsPerThread() {
        return this.cachedConnectionsPerThread;
    }

    public T cachedConnectionsPerThread(Integer value) {
        Integer oldValue = this.cachedConnectionsPerThread;
        this.cachedConnectionsPerThread = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cachedConnectionsPerThread", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-idle-timeout")
    public Integer connectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public T connectionIdleTimeout(Integer value) {
        Integer oldValue = this.connectionIdleTimeout;
        this.connectionIdleTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionIdleTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connections-per-thread")
    public Integer connectionsPerThread() {
        return this.connectionsPerThread;
    }

    public T connectionsPerThread(Integer value) {
        Integer oldValue = this.connectionsPerThread;
        this.connectionsPerThread = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionsPerThread", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-request-time")
    public Integer maxRequestTime() {
        return this.maxRequestTime;
    }

    public T maxRequestTime(Integer value) {
        Integer oldValue = this.maxRequestTime;
        this.maxRequestTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRequestTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-retries")
    public Integer maxRetries() {
        return this.maxRetries;
    }

    public T maxRetries(Integer value) {
        Integer oldValue = this.maxRetries;
        this.maxRetries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRetries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="problem-server-retry")
    public Integer problemServerRetry() {
        return this.problemServerRetry;
    }

    public T problemServerRetry(Integer value) {
        Integer oldValue = this.problemServerRetry;
        this.problemServerRetry = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("problemServerRetry", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-queue-size")
    public Integer requestQueueSize() {
        return this.requestQueueSize;
    }

    public T requestQueueSize(Integer value) {
        Integer oldValue = this.requestQueueSize;
        this.requestQueueSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestQueueSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="session-cookie-names")
    public String sessionCookieNames() {
        return this.sessionCookieNames;
    }

    public T sessionCookieNames(String value) {
        String oldValue = this.sessionCookieNames;
        this.sessionCookieNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sessionCookieNames", oldValue, value);
        }
        return (T)this;
    }

    public static class ReverseProxyResources {
        @ResourceDocumentation(value="A host that the reverse proxy will forward requests to")
        @SubresourceInfo(value="host")
        private List<Host> hosts = new ArrayList<Host>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }

        public Host host(String key) {
            return this.hosts.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

